/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.internal.Factory;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.InvalidComponentModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler;
import org.gradle.platform.base.internal.registry.TypeBuilderInternal;
import org.gradle.platform.base.internal.rules.RuleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentModelRuleDefinitionHandler<A extends Annotation, T, U extends T>
extends AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler<A> {
    private final String modelName;
    private final Class<A> annotationClass;
    private final ModelType<T> baseInterface;
    private final ModelType<U> baseImplementation;
    private final ModelType<?> builderInterface;
    private final Factory<? extends TypeBuilderInternal<T>> typeBuilderFactory;
    private final Action<? super RegistrationContext<T, U>> registerer;

    public ComponentModelRuleDefinitionHandler(String modelName, Class<A> annotationClass, Class<T> baseInterface, Class<U> baseImplementation, Class<?> builderInterface, Factory<? extends TypeBuilderInternal<T>> typeBuilderFactory, Action<? super RegistrationContext<T, U>> registerer) {
        this.modelName = modelName;
        this.annotationClass = annotationClass;
        this.typeBuilderFactory = typeBuilderFactory;
        this.registerer = registerer;
        this.baseInterface = ModelType.of(baseInterface);
        this.baseImplementation = ModelType.of(baseImplementation);
        this.builderInterface = ModelType.of(builderInterface);
    }

    public <R> void register(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        try {
            ModelType<T> type = this.readType(ruleDefinition);
            ModelType<U> implementation = this.determineImplementationType(ruleDefinition, type);
            dependencies.add(ComponentModelBasePlugin.class);
            if (implementation != null) {
                RegisterTypeRule<T, U> mutator = new RegisterTypeRule<T, U>(type, implementation, ruleDefinition.getDescriptor(), this.registerer);
                modelRegistry.mutate(mutator);
            }
        }
        catch (InvalidComponentModelException e) {
            this.invalidModelRule(ruleDefinition, e);
        }
    }

    protected ModelType<? extends T> readType(MethodRuleDefinition<?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        if (ruleDefinition.getReferences().size() != 1) {
            throw new InvalidComponentModelException(String.format("%s method must have a single parameter of type '%s'.", this.annotationClass.getSimpleName(), this.builderInterface.toString()));
        }
        ModelType builder = ((ModelReference)ruleDefinition.getReferences().get(0)).getType();
        if (!this.builderInterface.isAssignableFrom(builder)) {
            throw new InvalidComponentModelException(String.format("%s method must have a single parameter of type '%s'.", this.annotationClass.getSimpleName(), this.builderInterface.toString()));
        }
        if (builder.getTypeVariables().size() != 1) {
            throw new InvalidComponentModelException(String.format("Parameter of type '%s' must declare a type parameter.", this.builderInterface.toString()));
        }
        ModelType subType = (ModelType)builder.getTypeVariables().get(0);
        if (subType.isWildcard()) {
            throw new InvalidComponentModelException(String.format("%s type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", StringUtils.capitalize((String)this.modelName), subType.toString()));
        }
        ModelType asSubclass = this.baseInterface.asSubclass(subType);
        if (asSubclass == null) {
            throw new InvalidComponentModelException(String.format("%s type '%s' is not a subtype of '%s'.", StringUtils.capitalize((String)this.modelName), subType.toString(), this.baseInterface.toString()));
        }
        return asSubclass;
    }

    protected void invalidModelRule(MethodRuleDefinition<?> ruleDefinition, InvalidComponentModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(String.format(" is not a valid %s model rule method.", this.modelName));
        throw new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    protected ModelType<? extends U> determineImplementationType(MethodRuleDefinition<?> ruleDefinition, ModelType<? extends T> type) {
        TypeBuilderInternal builder = (TypeBuilderInternal)this.typeBuilderFactory.create();
        ruleDefinition.getRuleInvoker().invoke(new Object[]{builder});
        Class implementation = builder.getDefaultImplementation();
        if (implementation == null) {
            return null;
        }
        ModelType implementationType = ModelType.of(implementation);
        ModelType asSubclass = this.baseImplementation.asSubclass(implementationType);
        if (asSubclass == null) {
            throw new InvalidComponentModelException(String.format("%s implementation '%s' must extend '%s'.", StringUtils.capitalize((String)this.modelName), implementationType, this.baseImplementation));
        }
        if (!type.isAssignableFrom(asSubclass)) {
            throw new InvalidComponentModelException(String.format("%s implementation '%s' must implement '%s'.", StringUtils.capitalize((String)this.modelName), asSubclass, type));
        }
        try {
            asSubclass.getRawClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsmException) {
            throw new InvalidComponentModelException(String.format("%s implementation '%s' must have public default constructor.", StringUtils.capitalize((String)this.modelName), asSubclass));
        }
        return asSubclass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisterTypeRule<T, U>
    implements ModelMutator<ExtensionContainer> {
        private final ModelType<? extends T> type;
        private final ModelType<? extends U> implementation;
        private final ModelRuleDescriptor descriptor;
        private final ModelReference<ExtensionContainer> subject;
        private final List<ModelReference<?>> inputs;
        private final Action<? super RegistrationContext<T, U>> registerAction;

        protected RegisterTypeRule(ModelType<? extends T> type, ModelType<? extends U> implementation, ModelRuleDescriptor descriptor, Action<? super RegistrationContext<T, U>> registerAction) {
            this.type = type;
            this.implementation = implementation;
            this.descriptor = descriptor;
            this.registerAction = registerAction;
            this.subject = ModelReference.of((String)"extensions", ExtensionContainer.class);
            this.inputs = ImmutableList.of((Object)ModelReference.of(ProjectIdentifier.class));
        }

        public ModelReference<ExtensionContainer> getSubject() {
            return this.subject;
        }

        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final void mutate(final ExtensionContainer extensionContainer, final Inputs inputs) {
            RuleContext.inContext(this.getDescriptor(), new Runnable(){

                public void run() {
                    RegistrationContext context = new RegistrationContext(RegisterTypeRule.this.type, RegisterTypeRule.this.implementation, extensionContainer, (ProjectIdentifier)inputs.get(0, ModelType.of(ProjectIdentifier.class)).getInstance());
                    RegisterTypeRule.this.registerAction.execute(context);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RegistrationContext<T, U> {
        private final ModelType<? extends T> type;
        private final ModelType<? extends U> implementation;
        private final ExtensionContainer extensions;
        private final ProjectIdentifier projectIdentifier;

        public RegistrationContext(ModelType<? extends T> type, ModelType<? extends U> implementation, ExtensionContainer extensions, ProjectIdentifier projectIdentifier) {
            this.type = type;
            this.implementation = implementation;
            this.extensions = extensions;
            this.projectIdentifier = projectIdentifier;
        }

        public ModelType<? extends T> getType() {
            return this.type;
        }

        public ModelType<? extends U> getImplementation() {
            return this.implementation;
        }

        public ExtensionContainer getExtensions() {
            return this.extensions;
        }

        public ProjectIdentifier getProjectIdentifier() {
            return this.projectIdentifier;
        }
    }
}

