/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.model.internal.core.ModelType;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.ComponentModelRuleDefinitionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeRuleDefinitionHandler
extends ComponentModelRuleDefinitionHandler<ComponentType, ComponentSpec, BaseComponentSpec> {
    public ComponentTypeRuleDefinitionHandler(Instantiator instantiator) {
        super("component", ComponentType.class, ComponentSpec.class, BaseComponentSpec.class, ComponentTypeBuilder.class, JavaReflectionUtil.factory((Instantiator)new DirectInstantiator(), DefaultComponentTypeBuilder.class, (Object[])new Object[0]), new RegistrationAction(instantiator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction
    implements Action<ComponentModelRuleDefinitionHandler.RegistrationContext<ComponentSpec, BaseComponentSpec>> {
        private final Instantiator instantiator;

        public RegistrationAction(Instantiator instantiator) {
            this.instantiator = instantiator;
        }

        public void execute(ComponentModelRuleDefinitionHandler.RegistrationContext<ComponentSpec, BaseComponentSpec> context) {
            ExtensionContainer extensions = context.getExtensions();
            ProjectSourceSet projectSourceSet = (ProjectSourceSet)extensions.getByType(ProjectSourceSet.class);
            ComponentSpecContainer componentSpecs = (ComponentSpecContainer)extensions.getByType(ComponentSpecContainer.class);
            this.doRegister(context.getType(), context.getImplementation(), projectSourceSet, componentSpecs, context.getProjectIdentifier());
        }

        private <T extends ComponentSpec, I extends BaseComponentSpec> void doRegister(ModelType<T> type, final ModelType<I> implementation, final ProjectSourceSet projectSourceSet, ComponentSpecContainer componentSpecs, final ProjectIdentifier projectIdentifier) {
            componentSpecs.registerFactory(type.getConcreteClass(), new NamedDomainObjectFactory<T>(){

                public T create(String name) {
                    FunctionalSourceSet componentSourceSet = (FunctionalSourceSet)projectSourceSet.maybeCreate(name);
                    DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(projectIdentifier.getPath(), name);
                    Object created = BaseComponentSpec.create(implementation.getConcreteClass(), id, componentSourceSet, RegistrationAction.this.instantiator);
                    return created;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComponentTypeBuilder
    extends AbstractTypeBuilder<ComponentSpec>
    implements ComponentTypeBuilder<ComponentSpec> {
        public DefaultComponentTypeBuilder() {
            super(ComponentType.class);
        }
    }
}

