/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.rules;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.platform.base.internal.rules.RuleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleAwarePolymorphicDomainObjectContainer<T>
extends DefaultPolymorphicDomainObjectContainer<T> {
    private final Map<Class<? extends T>, ModelRuleDescriptor> creators = Maps.newHashMap();

    public RuleAwarePolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    public RuleAwarePolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator) {
        super(type, instantiator);
    }

    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        this.checkCanRegister(type);
        super.registerFactory(type, factory);
    }

    private void checkCanRegister(Class<? extends T> type) {
        ModelRuleDescriptor creator = this.creators.get(type);
        if (creator != null) {
            StringBuilder builder = new StringBuilder("Cannot register a factory for type ").append(type.getSimpleName()).append(" because a factory for this type was already registered by ");
            creator.describeTo((Appendable)builder);
            builder.append(".");
            throw new GradleException(builder.toString());
        }
        this.creators.put(type, RuleContext.get());
    }
}

