/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.mvn3.org.sonatype.aether.artifact.Artifact;
import org.gradle.mvn3.org.sonatype.aether.impl.MetadataGenerator;
import org.gradle.mvn3.org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.gradle.mvn3.org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    private static final Comparator<MetadataGeneratorFactory> COMPARATOR = new Comparator<MetadataGeneratorFactory>(){

        @Override
        public int compare(MetadataGeneratorFactory o1, MetadataGeneratorFactory o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    Utils() {
    }

    public static List<MetadataGeneratorFactory> sortMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> factories) {
        ArrayList<MetadataGeneratorFactory> result = new ArrayList<MetadataGeneratorFactory>(factories);
        Collections.sort(result, COMPARATOR);
        return result;
    }

    public static List<Metadata> prepareMetadata(List<MetadataGenerator> generators, List<Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator generator : generators) {
            metadatas.addAll(generator.prepare(artifacts));
        }
        return metadatas;
    }

    public static List<Metadata> finishMetadata(List<MetadataGenerator> generators, List<Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator generator : generators) {
            metadatas.addAll(generator.finish(artifacts));
        }
        return metadatas;
    }

    public static <T> List<T> combine(Collection<? extends T> first, Collection<? extends T> second) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }
}

