/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import groovy.lang.Closure;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publication.maven.internal.CustomModelBuilder;
import org.gradle.api.publication.maven.internal.PomDependenciesConverter;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenPom
implements MavenPom {
    private PomDependenciesConverter pomDependenciesConverter;
    private FileResolver fileResolver;
    private MavenProject mavenProject = new MavenProject();
    private Conf2ScopeMappingContainer scopeMappings;
    private ActionBroadcast<MavenPom> whenConfiguredActions = new ActionBroadcast();
    private XmlTransformer withXmlActions = new XmlTransformer();
    private ConfigurationContainer configurations;

    public DefaultMavenPom(ConfigurationContainer configurationContainer, Conf2ScopeMappingContainer scopeMappings, PomDependenciesConverter pomDependenciesConverter, FileResolver fileResolver) {
        this.configurations = configurationContainer;
        this.scopeMappings = scopeMappings;
        this.pomDependenciesConverter = pomDependenciesConverter;
        this.fileResolver = fileResolver;
        this.mavenProject.setModelVersion("4.0.0");
    }

    @Override
    public Conf2ScopeMappingContainer getScopeMappings() {
        return this.scopeMappings;
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        return this.configurations;
    }

    @Override
    public DefaultMavenPom setConfigurations(ConfigurationContainer configurations) {
        this.configurations = configurations;
        return this;
    }

    @Override
    public DefaultMavenPom setGroupId(String groupId) {
        this.getModel().setGroupId(groupId);
        return this;
    }

    @Override
    public String getGroupId() {
        return this.getModel().getGroupId();
    }

    @Override
    public DefaultMavenPom setArtifactId(String artifactId) {
        this.getModel().setArtifactId(artifactId);
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    @Override
    public DefaultMavenPom setDependencies(List<?> dependencies) {
        this.getModel().setDependencies(dependencies);
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.getModel().getDependencies();
    }

    public DefaultMavenPom setName(String name) {
        this.getModel().setName(name);
        return this;
    }

    public String getName() {
        return this.getModel().getName();
    }

    @Override
    public DefaultMavenPom setVersion(String version) {
        this.getModel().setVersion(version);
        return this;
    }

    @Override
    public String getVersion() {
        return this.getModel().getVersion();
    }

    @Override
    public String getPackaging() {
        return this.getModel().getPackaging();
    }

    @Override
    public DefaultMavenPom setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
        return this;
    }

    @Override
    public DefaultMavenPom project(Closure cl) {
        CustomModelBuilder pomBuilder = new CustomModelBuilder(this.getModel());
        InvokerHelper.invokeMethod((Object)((Object)pomBuilder), (String)"project", (Object)cl);
        return this;
    }

    public Model getModel() {
        return this.mavenProject.getModel();
    }

    @Override
    public DefaultMavenPom setModel(Object model) {
        this.mavenProject = new MavenProject((Model)model);
        return this;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public DefaultMavenPom setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }

    public List<Dependency> getGeneratedDependencies() {
        if (this.configurations == null) {
            return Collections.emptyList();
        }
        return this.pomDependenciesConverter.convert(this.getScopeMappings(), (Set<Configuration>)this.configurations);
    }

    @Override
    public DefaultMavenPom getEffectivePom() {
        DefaultMavenPom effectivePom = new DefaultMavenPom(null, this.scopeMappings, this.pomDependenciesConverter, this.fileResolver);
        try {
            effectivePom.setMavenProject((MavenProject)this.mavenProject.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        effectivePom.getDependencies().addAll(this.getGeneratedDependencies());
        effectivePom.withXmlActions = this.withXmlActions;
        this.whenConfiguredActions.execute((Object)effectivePom);
        return effectivePom;
    }

    public PomDependenciesConverter getPomDependenciesConverter() {
        return this.pomDependenciesConverter;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public DefaultMavenPom setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        return this;
    }

    @Override
    public DefaultMavenPom writeTo(Writer pomWriter) {
        try {
            this.getEffectivePom().writeNonEffectivePom(pomWriter);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return this;
    }

    @Override
    public DefaultMavenPom writeTo(Object path) {
        IoActions.writeTextFile((File)this.fileResolver.resolve(path), (String)"UTF-8", (Action)new Action<BufferedWriter>(){

            public void execute(BufferedWriter writer) {
                DefaultMavenPom.this.writeTo(writer);
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNonEffectivePom(Writer pomWriter) throws IOException {
        try {
            this.withXmlActions.transform(pomWriter, "UTF-8", (Action)new ErroringAction<Writer>(){

                protected void doExecute(Writer writer) throws IOException {
                    DefaultMavenPom.this.mavenProject.writeModel(writer);
                }
            });
        }
        finally {
            pomWriter.close();
        }
    }

    @Override
    public DefaultMavenPom whenConfigured(Closure closure) {
        this.whenConfiguredActions.add((Action)new ClosureBackedAction(closure));
        return this;
    }

    @Override
    public DefaultMavenPom whenConfigured(Action<MavenPom> action) {
        this.whenConfiguredActions.add(action);
        return this;
    }

    @Override
    public DefaultMavenPom withXml(Closure closure) {
        this.withXmlActions.addAction(closure);
        return this;
    }

    @Override
    public DefaultMavenPom withXml(Action<XmlProvider> action) {
        this.withXmlActions.addAction(action);
        return this;
    }
}

