/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publication.maven.internal.ant.CustomDeployTask;
import org.gradle.api.publish.maven.internal.publisher.AbstractAntTaskBackedMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.MavenRemoteRepositoryFactory;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntTaskBackedMavenPublisher
extends AbstractAntTaskBackedMavenPublisher<CustomDeployTask> {
    public AntTaskBackedMavenPublisher(Factory<LoggingManagerInternal> loggingManagerFactory, Factory<File> temporaryDirFactory) {
        super(loggingManagerFactory, temporaryDirFactory);
    }

    @Override
    protected void postConfigure(CustomDeployTask task, MavenArtifactRepository artifactRepository) {
        this.addRepository(task, artifactRepository);
    }

    @Override
    protected CustomDeployTask createDeployTask() {
        DeployTask deployTask = new DeployTask((Factory<File>)this.temporaryDirFactory);
        deployTask.setUniqueVersion(true);
        return deployTask;
    }

    private void addRepository(CustomDeployTask deployTask, MavenArtifactRepository artifactRepository) {
        RemoteRepository mavenRepository = new MavenRemoteRepositoryFactory(artifactRepository).create();
        deployTask.addRemoteRepository(mavenRepository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeployTask
    extends CustomDeployTask {
        private final Factory<File> tmpDirFactory;

        public DeployTask(Factory<File> tmpDirFactory) {
            this.tmpDirFactory = tmpDirFactory;
        }

        protected ArtifactRepository createLocalArtifactRepository() {
            ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, this.getLocalRepository().getLayout());
            return new DefaultArtifactRepository("local", ((File)this.tmpDirFactory.create()).toURI().toString(), repositoryLayout);
        }

        protected void updateRepositoryWithSettings(RemoteRepository repository) {
        }
    }
}

