/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.AntTaskBackedMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.StaticLockingMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PublishToMavenRepository
extends DefaultTask {
    private MavenPublicationInternal publication;
    private MavenArtifactRepository repository;

    public PublishToMavenRepository() {
        this.getInputs().files(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                MavenPublicationInternal publicationInternal = PublishToMavenRepository.this.getPublicationInternal();
                return publicationInternal == null ? null : publicationInternal.getPublishableFiles();
            }
        }});
    }

    public MavenPublication getPublication() {
        return this.publication;
    }

    public void setPublication(MavenPublication publication) {
        this.publication = PublishToMavenRepository.toPublicationInternal(publication);
    }

    private MavenPublicationInternal getPublicationInternal() {
        return PublishToMavenRepository.toPublicationInternal(this.getPublication());
    }

    private static MavenPublicationInternal toPublicationInternal(MavenPublication publication) {
        if (publication == null) {
            return null;
        }
        if (publication instanceof MavenPublicationInternal) {
            return (MavenPublicationInternal)publication;
        }
        throw new InvalidUserDataException(String.format("publication objects must implement the '%s' interface, implementation '%s' does not", MavenPublicationInternal.class.getName(), publication.getClass().getName()));
    }

    public MavenArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository = repository;
    }

    @TaskAction
    public void publish() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        MavenArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.doPublish(publicationInternal, repository);
    }

    @Inject
    protected Factory<LoggingManagerInternal> getLoggingManagerFactory() {
        throw new UnsupportedOperationException();
    }

    protected void doPublish(final MavenPublicationInternal publication, final MavenArtifactRepository repository) {
        new PublishOperation(publication, (ArtifactRepository)repository){

            protected void publish() throws Exception {
                AntTaskBackedMavenPublisher antBackedPublisher = new AntTaskBackedMavenPublisher(PublishToMavenRepository.this.getLoggingManagerFactory(), (Factory<File>)PublishToMavenRepository.this.getTemporaryDirFactory());
                StaticLockingMavenPublisher staticLockingPublisher = new StaticLockingMavenPublisher(antBackedPublisher);
                ValidatingMavenPublisher validatingPublisher = new ValidatingMavenPublisher(staticLockingPublisher);
                validatingPublisher.publish(publication.asNormalisedPublication(), repository);
            }
        }.run();
    }
}

