/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.gradle.mvn3.org.sonatype.aether.graph.Dependency;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyFilter;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDependencyFilter
implements DependencyFilter {
    private final Collection<String> included = new HashSet<String>();
    private final Collection<String> excluded = new HashSet<String>();

    public ScopeDependencyFilter(Collection<String> included, Collection<String> excluded) {
        if (included != null) {
            this.included.addAll(included);
        }
        if (excluded != null) {
            this.excluded.addAll(excluded);
        }
    }

    public ScopeDependencyFilter(String ... excluded) {
        if (excluded != null) {
            this.excluded.addAll(Arrays.asList(excluded));
        }
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        String scope = node.getDependency().getScope();
        return !(!this.included.isEmpty() && !this.included.contains(scope) || !this.excluded.isEmpty() && this.excluded.contains(scope));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencyFilter that = (ScopeDependencyFilter)obj;
        return ((Object)this.included).equals(that.included) && ((Object)this.excluded).equals(that.excluded);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + ((Object)this.included).hashCode();
        hash = hash * 31 + ((Object)this.excluded).hashCode();
        return hash;
    }
}

