/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.util.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyFilter;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyNode;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyVisitor;
import org.gradle.mvn3.org.sonatype.aether.util.graph.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRecordingDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final List<List<DependencyNode>> paths;
    private final Stack<DependencyNode> parents;
    private final boolean excludeChildrenOfMatches;

    public PathRecordingDependencyVisitor(DependencyFilter filter) {
        this(filter, true);
    }

    public PathRecordingDependencyVisitor(DependencyFilter filter, boolean excludeChildrenOfMatches) {
        this.filter = filter;
        this.excludeChildrenOfMatches = excludeChildrenOfMatches;
        this.paths = new ArrayList<List<DependencyNode>>();
        this.parents = new Stack();
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public List<List<DependencyNode>> getPaths() {
        return this.paths;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean accept = this.filter == null || this.filter.accept(node, this.parents);
        this.parents.push(node);
        if (accept) {
            DependencyNode[] path = new DependencyNode[this.parents.size()];
            int i = this.parents.size() - 1;
            Iterator i$ = this.parents.iterator();
            while (i$.hasNext()) {
                DependencyNode n;
                path[i] = n = (DependencyNode)i$.next();
                --i;
            }
            this.paths.add(Arrays.asList(path));
        }
        return !this.excludeChildrenOfMatches || !accept;
    }

    public boolean visitLeave(DependencyNode node) {
        this.parents.pop();
        return true;
    }
}

