/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.io.File;
import java.util.Map;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class NativeBinaryRules
extends RuleSource {
    @Defaults
    void addToolExtensions(NativeBinarySpec nativeBinarySpec, LanguageTransformContainer languageTransforms) {
        for (LanguageTransform language : languageTransforms) {
            Map binaryTools = language.getBinaryTools();
            for (String toolName : binaryTools.keySet()) {
                ((ExtensionAware)nativeBinarySpec).getExtensions().create(toolName, (Class)binaryTools.get(toolName), new Object[0]);
            }
        }
    }

    @Defaults
    public static void assignTools(NativeBinarySpec nativeBinarySpec, NativeToolChainRegistryInternal toolChains, File buildDir) {
        NativeBinarySpecInternal binarySpecInternal = (NativeBinarySpecInternal)nativeBinarySpec;
        NativeToolChainInternal toolChain = (NativeToolChainInternal)toolChains.getForPlatform(nativeBinarySpec.getTargetPlatform());
        binarySpecInternal.setToolChain(toolChain);
        PlatformToolProvider toolProvider = toolChain.select((NativePlatformInternal)nativeBinarySpec.getTargetPlatform());
        binarySpecInternal.setPlatformToolProvider(toolProvider);
        File binariesOutputDir = new File(buildDir, "binaries");
        BinaryNamingScheme namingScheme = binarySpecInternal.getNamingScheme();
        File binaryOutputDir = new File(binariesOutputDir, namingScheme.getOutputDirectoryBase());
        String baseName = binarySpecInternal.getComponent().getBaseName();
        if (binarySpecInternal instanceof NativeExecutableBinarySpec) {
            ((NativeExecutableBinarySpec)((Object)binarySpecInternal)).setExecutableFile(new File(binaryOutputDir, toolProvider.getExecutableName(baseName)));
        } else if (binarySpecInternal instanceof SharedLibraryBinarySpec) {
            ((SharedLibraryBinarySpec)((Object)binarySpecInternal)).setSharedLibraryFile(new File(binaryOutputDir, toolProvider.getSharedLibraryName(baseName)));
            ((SharedLibraryBinarySpec)((Object)binarySpecInternal)).setSharedLibraryLinkFile(new File(binaryOutputDir, toolProvider.getSharedLibraryLinkFileName(baseName)));
        } else if (binarySpecInternal instanceof StaticLibraryBinarySpec) {
            ((StaticLibraryBinarySpec)((Object)binarySpecInternal)).setStaticLibraryFile(new File(binaryOutputDir, toolProvider.getStaticLibraryName(baseName)));
        }
    }
}

