/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.rules.ModelMapCreators;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.test.TestSuiteContainer;
import org.gradle.platform.base.test.TestSuiteSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeBinariesTestPlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;
    private final ModelSchemaStore schemaStore;

    @Inject
    public NativeBinariesTestPlugin(ModelRegistry modelRegistry, ModelSchemaStore schemaStore) {
        this.modelRegistry = modelRegistry;
        this.schemaStore = schemaStore;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentPlugin.class);
        SimpleModelRuleDescriptor descriptor = new SimpleModelRuleDescriptor(NativeBinariesTestPlugin.class.getName() + ".apply()");
        SpecializedMapSchema schema = (SpecializedMapSchema)this.schemaStore.getSchema(ModelType.of(TestSuiteContainer.class));
        ModelCreator testSuitesCreator = ModelMapCreators.specialized((ModelPath)ModelPath.path((String)"testSuites"), TestSuiteSpec.class, TestSuiteContainer.class, schema.getImplementationType().asSubclass(TestSuiteContainer.class), (ModelRuleDescriptor)descriptor);
        this.modelRegistry.create(testSuitesCreator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Finalize
        void attachTestedBinarySourcesToTestBinaries(BinaryContainer binaries) {
            for (NativeTestSuiteBinarySpecInternal testSuiteBinary : binaries.withType(NativeTestSuiteBinarySpecInternal.class)) {
                NativeBinarySpecInternal testedBinary = (NativeBinarySpecInternal)testSuiteBinary.getTestedBinary();
                for (DependentSourceSet testSource : testSuiteBinary.getInputs().withType(DependentSourceSet.class)) {
                    testSource.lib(testedBinary.getInputs());
                }
                testSuiteBinary.getInputs().addAll((Collection)testedBinary.getInputs());
            }
        }

        @Finalize
        public void createTestTasks(TaskContainer tasks, BinaryContainer binaries) {
            for (NativeTestSuiteBinarySpec testBinary : binaries.withType(NativeTestSuiteBinarySpec.class)) {
                NativeBinarySpecInternal binary = (NativeBinarySpecInternal)((Object)testBinary);
                BinaryNamingScheme namingScheme = binary.getNamingScheme();
                RunTestExecutable runTask = (RunTestExecutable)tasks.create(namingScheme.getTaskName("run"), RunTestExecutable.class);
                Project project = runTask.getProject();
                runTask.setDescription(String.format("Runs the %s", binary));
                InstallExecutable installTask = (InstallExecutable)((Object)binary.getTasks().withType(InstallExecutable.class).iterator().next());
                runTask.getInputs().files(new Object[]{installTask.getOutputs().getFiles()});
                runTask.setExecutable(installTask.getRunScript().getPath());
                runTask.setOutputDir(new File(project.getBuildDir(), "/test-results/" + namingScheme.getOutputDirectoryBase()));
                testBinary.getTasks().add((Object)runTask);
            }
        }

        @Mutate
        public void copyTestBinariesToGlobalContainer(BinaryContainer binaries, TestSuiteContainer testSuites) {
            for (TestSuiteSpec testSuite : testSuites.withType(TestSuiteSpec.class).values()) {
                binaries.addAll(testSuite.getBinaries().values());
            }
        }

        @Mutate
        void attachBinariesToCheckLifecycle(ModelMap<Task> tasks, final BinaryContainer binaries) {
            tasks.named("check", (Action)new Action<Task>(){

                public void execute(Task checkTask) {
                    for (NativeTestSuiteBinarySpec testBinary : binaries.withType(NativeTestSuiteBinarySpec.class)) {
                        checkTask.dependsOn(new Object[]{testBinary.getTasks().getRun()});
                    }
                }
            });
        }
    }
}

