/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.assembler.plugins.internal;

import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.assembler.tasks.Assemble;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.BinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssembleTaskConfig
implements SourceTransformTaskConfig {
    public String getTaskPrefix() {
        return "assemble";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return Assemble.class;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
        this.configureAssembleTask((Assemble)task, (NativeBinarySpecInternal)binary, (LanguageSourceSetInternal)sourceSet);
    }

    private void configureAssembleTask(Assemble task, NativeBinarySpecInternal binary, LanguageSourceSetInternal sourceSet) {
        task.setDescription(String.format("Assembles the %s of %s", sourceSet, binary));
        task.setToolChain(binary.getToolChain());
        task.setTargetPlatform(binary.getTargetPlatform());
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setObjectFileDir(project.file((Object)(project.getBuildDir() + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + sourceSet.getFullName())));
        Tool assemblerTool = (Tool)((ExtensionAware)binary).getExtensions().getByName("assembler");
        task.setAssemblerArgs(assemblerTool.getArgs());
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

