/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.server.Daemon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedDaemonStarter
implements DaemonStarter,
Stoppable {
    private final Factory<Daemon> daemonFactory;
    private final List<Daemon> daemons = new ArrayList<Daemon>();
    private final Lock daemonsLock = new ReentrantLock();

    public EmbeddedDaemonStarter(Factory<Daemon> daemonFactory) {
        this.daemonFactory = daemonFactory;
    }

    @Override
    public DaemonStartupInfo startDaemon() {
        Daemon daemon = this.daemonFactory.create();
        this.startDaemon(daemon);
        return new DaemonStartupInfo(daemon.getUid(), daemon.getAddress(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDaemon(Daemon daemon) {
        this.daemonsLock.lock();
        try {
            this.daemons.add(daemon);
        }
        finally {
            this.daemonsLock.unlock();
        }
        daemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList<Daemon> daemonsToStop;
        this.daemonsLock.lock();
        try {
            daemonsToStop = new ArrayList<Daemon>(this.daemons);
            this.daemons.clear();
        }
        finally {
            this.daemonsLock.unlock();
        }
        CompositeStoppable.stoppable(daemonsToStop).stop();
    }
}

