/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.classloading.GroovyJava7RuntimeMemoryLeakStrategy;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryLeakPrevention {
    private static final Logger LOG = Logging.getLogger(MemoryLeakPrevention.class);
    private final String name;
    private final Set<Strategy> strategies;
    private final ClassLoader leakingLoader;

    public MemoryLeakPrevention(String name, ClassLoader leakingLoader, ClassPath classPath) {
        this(name, leakingLoader, classPath, new GroovyJava7RuntimeMemoryLeakStrategy());
    }

    public MemoryLeakPrevention(String name, ClassLoader leakingLoader, final ClassPath classPath, Strategy ... strategies) {
        this.name = name;
        this.strategies = Sets.newHashSet((Iterable)Iterables.filter(Arrays.asList(strategies), (Predicate)new Predicate<Strategy>(){

            public boolean apply(Strategy input) {
                return input.appliesTo(classPath);
            }
        }));
        this.leakingLoader = leakingLoader;
    }

    public ClassLoader getLeakingLoader() {
        return this.leakingLoader;
    }

    private void doWithClassPath(Action<? super Strategy> action) {
        for (Strategy strategy : this.strategies) {
            action.execute((Object)strategy);
        }
    }

    public void dispose(final ClassLoader ... affectedLoaders) {
        LOG.debug(String.format("Clearing leaking classloader [%s] from %s", this.name, Arrays.toString(affectedLoaders)));
        this.doWithClassPath((Action<? super Strategy>)new ErroringAction<Strategy>(){

            protected void doExecute(Strategy strategy) throws Exception {
                strategy.dispose(MemoryLeakPrevention.this.leakingLoader, affectedLoaders);
            }
        });
    }

    public void prepare(final ClassLoader ... affectedLoaders) {
        this.doWithClassPath((Action<? super Strategy>)new ErroringAction<Strategy>(){

            protected void doExecute(Strategy strategy) throws Exception {
                strategy.prepare(MemoryLeakPrevention.this.leakingLoader, affectedLoaders);
            }
        });
    }

    public static abstract class Strategy {
        public boolean appliesTo(ClassPath classpath) {
            return false;
        }

        public void prepare(ClassLoader leakingLoader, ClassLoader ... affectedLoaders) throws Exception {
        }

        public void dispose(ClassLoader classLoader, ClassLoader ... affectedLoaders) throws Exception {
        }
    }
}

