/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.tasks.Nested;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBeanPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Nested.class;
    }

    @Override
    public void attachActions(final PropertyActionContext context) {
        Class<?> nestedType = context.getInstanceVariableType();
        if (nestedType == null) {
            nestedType = context.getType();
        }
        context.attachActions(nestedType);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, final Callable<Object> futureValue) {
                task.getInputs().property(context.getName() + ".class", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object bean = futureValue.call();
                        return bean == null ? null : bean.getClass().getName();
                    }
                });
            }
        });
    }
}

