/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.internal.BuildDirHolder;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.ComponentSpec;

public class JarBinaryRules
extends RuleSource {
    @Defaults
    void configureJarBinaries(ComponentSpec jvmLibrary, BuildDirHolder buildDirHolder, final JavaToolChainRegistry toolChains) {
        final File binariesDir = new File(buildDirHolder.getBuildDir(), "jars");
        final File classesDir = new File(buildDirHolder.getBuildDir(), "classes");
        jvmLibrary.getBinaries().withType(JarBinarySpec.class).beforeEach((Action)new Action<JarBinarySpec>(){

            public void execute(JarBinarySpec jarBinary) {
                File outputDir = new File(classesDir, jarBinary.getName());
                jarBinary.setClassesDir(outputDir);
                jarBinary.setResourcesDir(outputDir);
                jarBinary.setJarFile(new File(binariesDir, String.format("%s/%s.jar", jarBinary.getName(), jarBinary.getId().getLibraryName())));
                jarBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(jarBinary.getTargetPlatform()));
            }
        });
    }
}

