/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks;

import groovy.lang.Closure;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MapFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParallelizableTask
@Incubating
public class Jar
extends Zip {
    public static final String DEFAULT_EXTENSION = "jar";
    private Manifest manifest;
    private final CopySpecInternal metaInf;

    public Jar() {
        this.setExtension(DEFAULT_EXTENSION);
        this.manifest = new DefaultManifest(this.getFileResolver());
        this.metaInf = (CopySpecInternal)this.getRootSpec().addFirst().into((Object)"META-INF");
        this.metaInf.addChild().from(new Object[]{new Callable<FileTreeAdapter>(){

            @Override
            public FileTreeAdapter call() throws Exception {
                MapFileTree manifestSource = new MapFileTree(Jar.this.getTemporaryDirFactory(), (Chmod)Jar.this.getFileSystem());
                manifestSource.add("MANIFEST.MF", (Action)new Action<OutputStream>(){

                    public void execute(OutputStream outputStream) {
                        Manifest manifest = Jar.this.getManifest();
                        if (manifest == null) {
                            manifest = new DefaultManifest(null);
                        }
                        manifest.writeTo(new OutputStreamWriter(outputStream));
                    }
                });
                return new FileTreeAdapter((MinimalFileTree)manifestSource);
            }
        }});
        this.getMainSpec().eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails details) {
                if (details.getPath().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    details.exclude();
                }
            }
        });
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Jar manifest(Closure<?> configureClosure) {
        if (this.getManifest() == null) {
            this.manifest = new DefaultManifest(((ProjectInternal)this.getProject()).getFileResolver());
        }
        ConfigureUtil.configure(configureClosure, (Object)this.getManifest());
        return this;
    }

    public CopySpec getMetaInf() {
        return this.metaInf.addChild();
    }

    public CopySpec metaInf(Closure<?> configureClosure) {
        return (CopySpec)ConfigureUtil.configure(configureClosure, (Object)this.getMetaInf());
    }
}

