/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.internal.Transformers;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    @Override
    public ClassLoader getIsolatedSystemClassLoader() {
        return this.getSystemClassLoader().getParent();
    }

    @Override
    public ClassLoader createIsolatedClassLoader(Iterable<URI> uris) {
        return this.doCreateIsolatedClassLoader(CollectionUtils.collect(uris, Transformers.toURL()));
    }

    @Override
    public ClassLoader createIsolatedClassLoader(ClassPath classPath) {
        return this.doCreateIsolatedClassLoader(classPath.getAsURLs());
    }

    private ClassLoader doCreateIsolatedClassLoader(Collection<URL> classpath) {
        if (this.needJaxpImpl()) {
            try {
                classpath.add(ClasspathUtil.getClasspathForResource(this.getSystemClassLoader(), "META-INF/services/javax.xml.parsers.SAXParserFactory").toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), this.getIsolatedSystemClassLoader());
    }

    @Override
    public FilteringClassLoader createFilteringClassLoader(ClassLoader parent) {
        FilteringClassLoader classLoader = new FilteringClassLoader(parent);
        if (this.needJaxpImpl()) {
            ServiceLocator locator = new ServiceLocator(this.getSystemClassLoader());
            this.makeServiceVisible(locator, classLoader, SAXParserFactory.class);
            this.makeServiceVisible(locator, classLoader, DocumentBuilderFactory.class);
            this.makeServiceVisible(locator, classLoader, DatatypeFactory.class);
        }
        return classLoader;
    }

    @Override
    public ClassLoader createClassLoader(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec instanceof MultiParentClassLoader.Spec) {
            return new MultiParentClassLoader(parents);
        }
        if (parents.size() != 1) {
            throw new IllegalArgumentException("Expected a single parent.");
        }
        ClassLoader parent = parents.get(0);
        if (spec instanceof MutableURLClassLoader.Spec) {
            MutableURLClassLoader.Spec clSpec = (MutableURLClassLoader.Spec)spec;
            return new MutableURLClassLoader(parent, clSpec);
        }
        if (spec instanceof CachingClassLoader.Spec) {
            return new CachingClassLoader(parent);
        }
        if (spec instanceof FilteringClassLoader.Spec) {
            FilteringClassLoader.Spec clSpec = (FilteringClassLoader.Spec)spec;
            return new FilteringClassLoader(parent, clSpec);
        }
        throw new IllegalArgumentException(String.format("Don't know how to create a ClassLoader from spec %s", spec));
    }

    @Override
    public FilteringClassLoader createSystemFilteringClassLoader() {
        return this.createFilteringClassLoader(this.getSystemClassLoader());
    }

    private void makeServiceVisible(ServiceLocator locator, FilteringClassLoader classLoader, Class<?> serviceType) {
        classLoader.allowClass(locator.getFactory(serviceType).getImplementationClass());
        classLoader.allowResource("META-INF/services/" + serviceType.getName());
    }

    private boolean needJaxpImpl() {
        return ClassLoader.getSystemResource("META-INF/services/javax.xml.parsers.SAXParserFactory") != null;
    }

    private ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }
}

