/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.language.base.internal.DependentSourceSetInternal;
import org.gradle.language.base.internal.model.VariantsMetaData;

public class DependentSourceSetResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier binaryId;
    private final DependentSourceSetInternal sourceSet;
    private final ResolutionStrategyInternal resolutionStrategy = new DefaultResolutionStrategy();
    private final VariantsMetaData variants;

    public DependentSourceSetResolveContext(LibraryBinaryIdentifier binaryId, DependentSourceSetInternal sourceSet, VariantsMetaData variants) {
        this.binaryId = binaryId;
        this.sourceSet = sourceSet;
        this.variants = variants;
    }

    public String getName() {
        return "Component configuration";
    }

    public String getDisplayName() {
        return this.sourceSet.getDisplayName();
    }

    public LibraryBinaryIdentifier getComponentId() {
        return this.binaryId;
    }

    public DependentSourceSetInternal getSourceSet() {
        return this.sourceSet;
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public DependencySet getDependencies() {
        DefaultDomainObjectSet backingSet = new DefaultDomainObjectSet(Dependency.class);
        return new DefaultDependencySet(String.format("%s dependencies", this.getName()), (DomainObjectSet)backingSet);
    }

    public DependencySet getAllDependencies() {
        return new DefaultDependencySet(String.format("%s dependencies", this.getName()), (DomainObjectSet)new DefaultDomainObjectSet(Dependency.class));
    }
}

