/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary;

import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DefaultPolymorphicNamedEntityInstantiator;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.rules.NamedDomainObjectFactoryRegistry;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.DomainObjectCollectionBackedModelMap;
import org.gradle.model.internal.core.ModelMapGroovyDecorator;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseBinarySpec
extends AbstractBuildableModelElement
implements BinarySpecInternal {
    private final NamedDomainObjectFactoryRegistry<LanguageSourceSet> entityInstantiator;
    private final ModelMap<LanguageSourceSet> ownedSourceSets;
    private final DomainObjectSet<LanguageSourceSet> inputSourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private static ThreadLocal<BinaryInfo> nextBinaryInfo = new ThreadLocal();
    private final BinaryTasksCollection tasks;
    private final String name;
    private final String typeName;
    private final Class<? extends BinarySpec> publicType;
    private boolean disabled;

    public static <T extends BaseBinarySpec> T create(Class<? extends BinarySpec> publicType, Class<T> implementationType, String name, Instantiator instantiator, ITaskFactory taskFactory) {
        if (implementationType.equals(BaseBinarySpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseBinarySpec.");
        }
        nextBinaryInfo.set(new BinaryInfo(name, publicType, implementationType, taskFactory, instantiator));
        try {
            BaseBinarySpec baseBinarySpec = (BaseBinarySpec)instantiator.newInstance(implementationType, new Object[0]);
            return (T)baseBinarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create binary of type %s", implementationType.getSimpleName()), e.getCause());
        }
        finally {
            nextBinaryInfo.set(null);
        }
    }

    protected BaseBinarySpec() {
        this(nextBinaryInfo.get());
    }

    private BaseBinarySpec(BinaryInfo info) {
        DefaultPolymorphicNamedEntityInstantiator entityInstantiator;
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseBinarySpec is not permitted. Use a BinaryTypeBuilder instead.");
        }
        this.name = info.name;
        this.publicType = info.publicType;
        this.typeName = info.implementationType.getSimpleName();
        this.tasks = (BinaryTasksCollection)info.instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, info.taskFactory});
        this.entityInstantiator = entityInstantiator = new DefaultPolymorphicNamedEntityInstantiator(LanguageSourceSet.class, "owned sources");
        this.ownedSourceSets = new DomainObjectCollectionBackedModelMap<LanguageSourceSet>(LanguageSourceSet.class, (DomainObjectCollection<LanguageSourceSet>)new DefaultDomainObjectSet(LanguageSourceSet.class), (NamedEntityInstantiator<LanguageSourceSet>)entityInstantiator, (Namer<LanguageSourceSet>)new Named.Namer(), (Action<LanguageSourceSet>)Actions.doNothing());
    }

    @Override
    public Class<? extends BinarySpec> getPublicType() {
        return this.publicType;
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.getTypeName(), this.getName());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.disabled = !buildable;
    }

    @Override
    public final boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"source", (String)"inputs");
        return this.getInputs();
    }

    @Override
    public void sources(Action<? super ModelMap<LanguageSourceSet>> action) {
        action.execute(this.getSources());
    }

    @Override
    public NamedDomainObjectFactoryRegistry<LanguageSourceSet> getEntityInstantiator() {
        return this.entityInstantiator;
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getInputs() {
        return this.inputSourceSets;
    }

    @Override
    public ModelMap<LanguageSourceSet> getSources() {
        return ModelMapGroovyDecorator.wrap(this.ownedSourceSets);
    }

    @Override
    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    @Override
    public void tasks(Action<? super BinaryTasksCollection> action) {
        action.execute((Object)this.tasks);
    }

    @Override
    public boolean isLegacyBinary() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final BinaryBuildAbility getBuildAbility() {
        if (this.disabled) {
            return new FixedBuildAbility(false);
        }
        return this.getBinaryBuildAbility();
    }

    protected BinaryBuildAbility getBinaryBuildAbility() {
        return new FixedBuildAbility(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryInfo {
        private final String name;
        private final Class<? extends BinarySpec> publicType;
        private final Class<? extends BaseBinarySpec> implementationType;
        private final ITaskFactory taskFactory;
        private final Instantiator instantiator;

        private BinaryInfo(String name, Class<? extends BinarySpec> publicType, Class<? extends BaseBinarySpec> implementationType, ITaskFactory taskFactory, Instantiator instantiator) {
            this.name = name;
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.taskFactory = taskFactory;
            this.instantiator = instantiator;
        }
    }
}

