/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.Transformer;
import org.gradle.internal.BiAction;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultFunctionalSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.model.ModelMap;
import org.gradle.model.collection.internal.BridgedCollections;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.collection.internal.ModelMapModelProjection;
import org.gradle.model.collection.internal.PolymorphicModelMapProjection;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.registry.RuleContext;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseComponentSpec
implements ComponentSpecInternal {
    private static final Transformer<FunctionalSourceSet, MutableModelNode> PUSH_FUNCTIONAL_SOURCE_SET_TO_NODE = new Transformer<FunctionalSourceSet, MutableModelNode>(){

        public FunctionalSourceSet transform(MutableModelNode modelNode) {
            BaseComponentSpec componentSpec = (BaseComponentSpec)modelNode.getParent().getPrivateData(ModelType.of(ComponentSpec.class));
            return componentSpec.mainSourceSet;
        }
    };
    private static final Transformer<NamedEntityInstantiator<LanguageSourceSet>, MutableModelNode> SOURCE_SET_CREATOR = new Transformer<NamedEntityInstantiator<LanguageSourceSet>, MutableModelNode>(){

        public NamedEntityInstantiator<LanguageSourceSet> transform(final MutableModelNode modelNode) {
            return new NamedEntityInstantiator<LanguageSourceSet>(){

                public <S extends LanguageSourceSet> S create(String name, Class<S> type) {
                    FunctionalSourceSet sourceSet = (FunctionalSourceSet)modelNode.getPrivateData(FunctionalSourceSet.class);
                    LanguageSourceSet s = (LanguageSourceSet)sourceSet.getEntityInstantiator().create(name, type);
                    sourceSet.add(s);
                    return (S)s;
                }
            };
        }
    };
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();
    private final FunctionalSourceSet mainSourceSet;
    private final ComponentSpecIdentifier identifier;
    private final String typeName;
    private final MutableModelNode binaries;
    private final MutableModelNode sources;
    private MutableModelNode modelNode;

    public static <T extends BaseComponentSpec> T create(Class<T> type, ComponentSpecIdentifier identifier, MutableModelNode modelNode, ProjectSourceSet allSourceSets, Instantiator instantiator) {
        if (type.equals(BaseComponentSpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseComponentSpec.");
        }
        FunctionalSourceSet mainSourceSet = (FunctionalSourceSet)instantiator.newInstance(DefaultFunctionalSourceSet.class, new Object[]{identifier.getName(), instantiator, allSourceSets});
        nextComponentInfo.set(new ComponentInfo(identifier, modelNode, type.getSimpleName(), mainSourceSet, instantiator));
        try {
            BaseComponentSpec baseComponentSpec = (BaseComponentSpec)instantiator.newInstance(type, new Object[0]);
            return (T)baseComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    protected BaseComponentSpec() {
        this(nextComponentInfo.get());
    }

    private BaseComponentSpec(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a ComponentTypeBuilder instead.");
        }
        this.identifier = info.componentIdentifier;
        this.typeName = info.typeName;
        this.mainSourceSet = info.sourceSets;
        this.modelNode = info.modelNode;
        this.modelNode.addLink(ModelCreators.of((ModelPath)this.modelNode.getPath().child("binaries"), (ModelReference)ModelReference.of(NodeInitializerRegistry.class), (BiAction)new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode node, List<ModelView<?>> modelViews) {
                NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)modelViews.get(0).getInstance();
                ChildNodeInitializerStrategy childFactory = NodeBackedModelMap.createUsingRegistry((ModelType)ModelType.of(BinarySpec.class), (NodeInitializerRegistry)nodeInitializerRegistry);
                node.setPrivateData(ModelType.of(ChildNodeInitializerStrategy.class), (Object)childFactory);
            }
        }).descriptor(this.modelNode.getDescriptor(), ".binaries").withProjection(ModelMapModelProjection.unmanaged(BinarySpec.class, (ChildNodeInitializerStrategyAccessor)ChildNodeInitializerStrategyAccessors.fromPrivateData())).build());
        this.binaries = this.modelNode.getLink("binaries");
        assert (this.binaries != null);
        ModelPath sourcesNodePath = this.modelNode.getPath().child("sources");
        NestedModelRuleDescriptor sourcesDescriptor = new NestedModelRuleDescriptor(this.modelNode.getDescriptor(), ".sources");
        this.modelNode.addLink(BridgedCollections.creator((ModelReference)ModelReference.of((ModelPath)sourcesNodePath, FunctionalSourceSet.class), PUSH_FUNCTIONAL_SOURCE_SET_TO_NODE, (Namer)new Named.Namer(), (String)sourcesDescriptor.toString(), (Transformer)BridgedCollections.itemDescriptor((String)sourcesDescriptor.toString())).withProjection(PolymorphicModelMapProjection.ofEager(LanguageSourceSetInternal.PUBLIC_MODEL_TYPE, (ChildNodeInitializerStrategyAccessor)ChildNodeInitializerStrategyAccessors.constant((ChildNodeInitializerStrategy)NodeBackedModelMap.createUsingParentNode(SOURCE_SET_CREATOR)))).withProjection(UnmanagedModelProjection.of(FunctionalSourceSet.class)).build());
        this.sources = this.modelNode.getLink("sources");
        assert (this.sources != null);
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.getTypeName(), this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public ModelMap<LanguageSourceSet> getSource() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"source", (String)"sources");
        return this.getSources();
    }

    @Override
    public ModelMap<LanguageSourceSet> getSources() {
        this.sources.ensureUsable();
        return (ModelMap)this.sources.asWritable(ModelTypes.modelMap(LanguageSourceSet.class), RuleContext.nest((String)(this.modelNode.toString() + ".getSources()")), Collections.emptyList()).getInstance();
    }

    @Override
    public void sources(Action<? super ModelMap<LanguageSourceSet>> action) {
        action.execute(this.getSources());
    }

    @Override
    public ModelMap<BinarySpec> getBinaries() {
        this.binaries.ensureUsable();
        return (ModelMap)this.binaries.asWritable(ModelTypes.modelMap(BinarySpecInternal.PUBLIC_MODEL_TYPE), RuleContext.nest((String)(this.identifier.toString() + ".getBinaries()")), Collections.emptyList()).getInstance();
    }

    @Override
    public void binaries(Action<? super ModelMap<BinarySpec>> action) {
        action.execute(this.getBinaries());
    }

    @Override
    public FunctionalSourceSet getFunctionalSourceSet() {
        return this.mainSourceSet;
    }

    @Override
    public Set<? extends Class<? extends TransformationFileType>> getInputTypes() {
        return Collections.emptySet();
    }

    private static class ComponentInfo {
        final ComponentSpecIdentifier componentIdentifier;
        private final MutableModelNode modelNode;
        final String typeName;
        final FunctionalSourceSet sourceSets;
        final Instantiator instantiator;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, MutableModelNode modelNode, String typeName, FunctionalSourceSet sourceSets, Instantiator instantiator) {
            this.componentIdentifier = componentIdentifier;
            this.modelNode = modelNode;
            this.typeName = typeName;
            this.sourceSets = sourceSets;
            this.instantiator = instantiator;
        }
    }
}

