/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner;

import java.io.File;
import java.util.List;
import org.gradle.api.Incubating;
import org.gradle.api.internal.classpath.DefaultGradleDistributionLocator;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.InvalidRunnerConfigurationException;
import org.gradle.testkit.runner.UnexpectedBuildFailure;
import org.gradle.testkit.runner.UnexpectedBuildSuccess;
import org.gradle.testkit.runner.internal.DefaultGradleRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class GradleRunner {
    public static GradleRunner create() {
        DefaultGradleDistributionLocator gradleDistributionLocator = new DefaultGradleDistributionLocator(GradleRunner.class);
        File gradleHome = gradleDistributionLocator.getGradleHome();
        if (gradleHome == null) {
            try {
                File classpathForClass = ClasspathUtil.getClasspathForClass(GradleRunner.class);
                throw new IllegalStateException("Could not create a GradleRunner, as the GradleRunner class was loaded from " + classpathForClass + " which is not a Gradle distribution");
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create a GradleRunner, as the GradleRunner class was not loaded from a Gradle distribution");
            }
        }
        return new DefaultGradleRunner(gradleHome);
    }

    public abstract GradleRunner withTestKitDir(File var1);

    public abstract File getProjectDir();

    public abstract GradleRunner withProjectDir(File var1);

    public abstract List<String> getArguments();

    public abstract GradleRunner withArguments(List<String> var1);

    public abstract GradleRunner withArguments(String ... var1);

    public abstract List<? extends File> getPluginClasspath();

    public abstract GradleRunner withPluginClasspath(Iterable<? extends File> var1);

    public abstract BuildResult build() throws InvalidRunnerConfigurationException, UnexpectedBuildFailure;

    public abstract BuildResult buildAndFail() throws InvalidRunnerConfigurationException, UnexpectedBuildSuccess;
}

