/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.internal.DefaultBuildTask;
import org.gradle.testkit.runner.internal.GradleExecutionResult;
import org.gradle.testkit.runner.internal.GradleExecutor;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestKitGradleExecutor
implements GradleExecutor {
    public static final String TEST_KIT_DAEMON_DIR_NAME = "test-kit-daemon";

    public TestKitGradleExecutor() {
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                DefaultGradleConnector.close();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GradleExecutionResult run(File gradleHome, File gradleUserHome, File projectDir, List<String> buildArgs, List<String> jvmArgs, ClassPath injectedClassPath, boolean debug) {
        ByteArrayOutputStream standardOutput = new ByteArrayOutputStream();
        ByteArrayOutputStream standardError = new ByteArrayOutputStream();
        ArrayList<BuildTask> tasks = new ArrayList<BuildTask>();
        GradleConnector gradleConnector = this.buildConnector(gradleHome, gradleUserHome, projectDir, debug);
        ProjectConnection connection = null;
        try {
            connection = gradleConnector.connect();
            DefaultBuildLauncher launcher = (DefaultBuildLauncher)connection.newBuild();
            launcher.setStandardOutput((OutputStream)standardOutput);
            launcher.setStandardError((OutputStream)standardError);
            launcher.addProgressListener((ProgressListener)new TaskExecutionProgressListener(tasks));
            launcher.withArguments(buildArgs.toArray(new String[buildArgs.size()]));
            launcher.setJvmArguments(jvmArgs.toArray(new String[jvmArgs.size()]));
            launcher.withInjectedClassPath(injectedClassPath);
            launcher.run();
        }
        catch (BuildException t) {
            GradleExecutionResult gradleExecutionResult = new GradleExecutionResult(standardOutput, standardError, tasks, t);
            return gradleExecutionResult;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return new GradleExecutionResult(standardOutput, standardError, tasks);
    }

    private GradleConnector buildConnector(File gradleHome, File gradleUserHome, File projectDir, boolean debug) {
        DefaultGradleConnector gradleConnector = (DefaultGradleConnector)GradleConnector.newConnector();
        gradleConnector.useGradleUserHomeDir(gradleUserHome);
        gradleConnector.daemonBaseDir(new File(gradleUserHome, TEST_KIT_DAEMON_DIR_NAME));
        gradleConnector.forProjectDirectory(projectDir);
        gradleConnector.searchUpwards(false);
        gradleConnector.daemonMaxIdleTime(120, TimeUnit.SECONDS);
        gradleConnector.useInstallation(gradleHome);
        gradleConnector.embedded(debug);
        return gradleConnector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskExecutionProgressListener
    implements ProgressListener {
        private final List<BuildTask> tasks;
        private final Map<String, Integer> order = new HashMap<String, Integer>();

        public TaskExecutionProgressListener(List<BuildTask> tasks) {
            this.tasks = tasks;
        }

        public void statusChanged(ProgressEvent event) {
            if (event instanceof TaskStartEvent) {
                TaskStartEvent taskStartEvent = (TaskStartEvent)event;
                this.order.put(taskStartEvent.getDescriptor().getTaskPath(), this.tasks.size());
                this.tasks.add(null);
            }
            if (event instanceof TaskFinishEvent) {
                TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
                String taskPath = taskFinishEvent.getDescriptor().getTaskPath();
                TaskOperationResult result = taskFinishEvent.getResult();
                Integer index = this.order.get(taskPath);
                if (index == null) {
                    throw new IllegalStateException("Received task finish event for task " + taskPath + " without first receiving task start event");
                }
                this.tasks.set(index, this.determineBuildTask(result, taskPath));
            }
        }

        private BuildTask determineBuildTask(TaskOperationResult result, String taskPath) {
            if (this.isFailed(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.FAILED);
            }
            if (this.isSkipped(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.SKIPPED);
            }
            if (this.isUpToDate(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.UP_TO_DATE);
            }
            return this.createBuildTask(taskPath, TaskOutcome.SUCCESS);
        }

        private BuildTask createBuildTask(String taskPath, TaskOutcome outcome) {
            return new DefaultBuildTask(taskPath, outcome);
        }

        private boolean isFailed(TaskOperationResult result) {
            return result instanceof TaskFailureResult;
        }

        private boolean isSkipped(TaskOperationResult result) {
            return result instanceof TaskSkippedResult;
        }

        private boolean isUpToDate(TaskOperationResult result) {
            return result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isUpToDate();
        }
    }
}

