/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output;

import java.io.File;
import org.gradle.foundation.output.definitions.FileLinkDefinition;

public class FileLink {
    private File file;
    private int lineNumber;
    private int startingIndex;
    private int endingIndex;
    private FileLinkDefinition matchingDefinition;

    public FileLink(File file, int startingIndex, int endingIndex, int lineNumber, FileLinkDefinition matchingDefinition) {
        this.file = file;
        this.startingIndex = startingIndex;
        this.endingIndex = endingIndex;
        this.lineNumber = lineNumber;
        this.matchingDefinition = matchingDefinition;
    }

    public FileLink(File file, int startingIndex, int endingIndex, int lineNumber) {
        this(file, startingIndex, endingIndex, lineNumber, null);
    }

    public String toString() {
        return "file='" + this.file + "' startingIndex=" + this.startingIndex + " endingIndex=" + this.endingIndex + " line: " + this.lineNumber + (this.matchingDefinition != null ? " definition: " + this.matchingDefinition.getName() : "");
    }

    public int getLength() {
        return this.endingIndex - this.startingIndex;
    }

    public File getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartingIndex() {
        return this.startingIndex;
    }

    public int getEndingIndex() {
        return this.endingIndex;
    }

    void move(int amountToMove) {
        this.startingIndex += amountToMove;
        this.endingIndex += amountToMove;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileLink)) {
            return false;
        }
        FileLink otherFileLink = (FileLink)obj;
        return otherFileLink.endingIndex == this.endingIndex && otherFileLink.startingIndex == this.startingIndex && otherFileLink.lineNumber == this.lineNumber && otherFileLink.file.equals(this.file);
    }

    public int hashCode() {
        return this.endingIndex ^ this.startingIndex ^ this.lineNumber ^ this.file.hashCode();
    }
}

