/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToArtifactsConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBackedArtifactPublisher
implements ArtifactPublisher {
    private final ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter;
    private final DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter;
    private final ConfigurationsToArtifactsConverter configurationsToArtifactsConverter;
    private final IvyContextManager ivyContextManager;
    private final IvyDependencyPublisher dependencyPublisher;
    private final IvyModuleDescriptorWriter ivyModuleDescriptorWriter;

    public IvyBackedArtifactPublisher(ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter, DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter, ConfigurationsToArtifactsConverter configurationsToArtifactsConverter, IvyContextManager ivyContextManager, IvyDependencyPublisher dependencyPublisher, IvyModuleDescriptorWriter ivyModuleDescriptorWriter) {
        this.configurationsToModuleDescriptorConverter = configurationsToModuleDescriptorConverter;
        this.dependenciesToModuleDescriptorConverter = dependenciesToModuleDescriptorConverter;
        this.configurationsToArtifactsConverter = configurationsToArtifactsConverter;
        this.ivyContextManager = ivyContextManager;
        this.dependencyPublisher = dependencyPublisher;
        this.ivyModuleDescriptorWriter = ivyModuleDescriptorWriter;
    }

    @Override
    public void publish(final Iterable<? extends PublicationAwareRepository> repositories, final ModuleInternal module, final Configuration configuration, final File descriptor) throws PublishException {
        this.ivyContextManager.withIvy((Action<? super Ivy>)new Action<Ivy>(){

            public void execute(Ivy ivy) {
                BuildableIvyModulePublishMetaData publishMetaData;
                Set allConfigurations = configuration.getAll();
                Set configurationsToPublish = configuration.getHierarchy();
                if (descriptor != null) {
                    publishMetaData = IvyBackedArtifactPublisher.this.toPublishMetaData(module, allConfigurations);
                    IvyBackedArtifactPublisher.this.ivyModuleDescriptorWriter.write(publishMetaData.getModuleDescriptor(), publishMetaData.getArtifacts(), descriptor);
                }
                publishMetaData = IvyBackedArtifactPublisher.this.toPublishMetaData(module, configurationsToPublish);
                if (descriptor != null) {
                    Artifact artifact = MDArtifact.newIvyArtifact((ModuleDescriptor)publishMetaData.getModuleDescriptor());
                    publishMetaData.addArtifact(artifact, descriptor);
                }
                ArrayList<ModuleVersionPublisher> publishResolvers = new ArrayList<ModuleVersionPublisher>();
                for (PublicationAwareRepository repository : repositories) {
                    ModuleVersionPublisher publisher = repository.createPublisher();
                    publishResolvers.add(publisher);
                }
                IvyBackedArtifactPublisher.this.dependencyPublisher.publish(publishResolvers, publishMetaData);
            }
        });
    }

    private BuildableIvyModulePublishMetaData toPublishMetaData(ModuleInternal module, Set<? extends Configuration> configurations) {
        ModuleVersionIdentifier id = DefaultModuleVersionIdentifier.newId((Module)module);
        DefaultIvyModulePublishMetaData publishMetaData = new DefaultIvyModulePublishMetaData(id, module.getStatus());
        this.configurationsToModuleDescriptorConverter.addConfigurations(publishMetaData, configurations);
        this.dependenciesToModuleDescriptorConverter.addDependencyDescriptors(publishMetaData, configurations);
        this.configurationsToArtifactsConverter.addArtifacts(publishMetaData, configurations);
        return publishMetaData;
    }
}

