/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationBackedComponent;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToArtifactsConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.local.model.LocalComponentMetaData;

public class ConfigurationLocalComponentConverter
implements LocalComponentConverter {
    private final ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter;
    private final DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ConfigurationsToArtifactsConverter configurationsToArtifactsConverter;

    public ConfigurationLocalComponentConverter(ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter, DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter, ComponentIdentifierFactory componentIdentifierFactory, ConfigurationsToArtifactsConverter configurationsToArtifactsConverter) {
        this.configurationsToModuleDescriptorConverter = configurationsToModuleDescriptorConverter;
        this.dependenciesToModuleDescriptorConverter = dependenciesToModuleDescriptorConverter;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.configurationsToArtifactsConverter = configurationsToArtifactsConverter;
    }

    public boolean canConvert(Object source) {
        return source instanceof ConfigurationBackedComponent || source instanceof Configuration;
    }

    public LocalComponentMetaData convert(Object source) {
        ModuleInternal module;
        Set<? extends Configuration> configurations;
        if (source instanceof Configuration) {
            configurations = ((Configuration)source).getAll();
            module = ((ConfigurationInternal)source).getModule();
        } else {
            configurations = ((ConfigurationBackedComponent)source).getConfigurations();
            module = ((ConfigurationBackedComponent)source).getModule();
        }
        assert (configurations.size() > 0) : "No configurations found for module: " + module.getName() + ". Configure them or apply a plugin that does it.";
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        ModuleVersionIdentifier moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId((Module)module);
        DefaultLocalComponentMetaData metaData = new DefaultLocalComponentMetaData(moduleVersionIdentifier, componentIdentifier, module.getStatus());
        this.configurationsToModuleDescriptorConverter.addConfigurations(metaData, configurations);
        this.dependenciesToModuleDescriptorConverter.addDependencyDescriptors(metaData, configurations);
        this.configurationsToArtifactsConverter.addArtifacts(metaData, configurations);
        return metaData;
    }
}

