/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseInstanceFactory<T, P>
implements InstanceFactory<T, P> {
    private final String displayName;
    private final Map<Class<? extends T>, FactoryRegistration<? extends T>> factories = Maps.newIdentityHashMap();
    private final Map<Class<? extends T>, ImplementationTypeRegistration<? extends T>> implementationTypes = Maps.newIdentityHashMap();
    private final Map<Class<? extends T>, List<InternalViewRegistration>> internalViews = Maps.newIdentityHashMap();

    public BaseInstanceFactory(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public <S extends T> void registerFactory(ModelType<S> type, @Nullable ModelRuleDescriptor sourceRule, BiFunction<? extends S, ? super P, ? super MutableModelNode> factory) {
        FactoryRegistration<S> factoryRegistration = this.getFactoryRegistration(type);
        if (factoryRegistration != null) {
            throw new GradleException(this.getDuplicateRegistrationMessage("a factory", type, ((FactoryRegistration)factoryRegistration).source));
        }
        this.factories.put(type.getConcreteClass(), new FactoryRegistration<S>(sourceRule, factory));
    }

    @Override
    public <S extends T, I extends S> void registerImplementation(ModelType<S> type, @Nullable ModelRuleDescriptor sourceRule, ModelType<I> implementationType) {
        ImplementationTypeRegistration<S> implementationTypeRegistration = this.getImplementationTypeRegistration(type);
        if (implementationTypeRegistration != null) {
            throw new GradleException(this.getDuplicateRegistrationMessage("an implementation type", type, ((ImplementationTypeRegistration)implementationTypeRegistration).source));
        }
        this.implementationTypes.put(type.getConcreteClass(), new ImplementationTypeRegistration(sourceRule, implementationType));
    }

    @Override
    public <S extends T> void registerInternalView(ModelType<S> type, @Nullable ModelRuleDescriptor sourceRule, ModelType<?> internalViewType) {
        ArrayList internalViewRegistrations = this.getInternalViewRegistrations(type);
        if (internalViewRegistrations == null) {
            internalViewRegistrations = Lists.newArrayList();
            this.internalViews.put(type.getConcreteClass(), internalViewRegistrations);
        }
        internalViewRegistrations.add(new InternalViewRegistration(sourceRule, internalViewType));
    }

    private <S extends T> String getDuplicateRegistrationMessage(String entity, ModelType<S> publicType, @Nullable ModelRuleDescriptor source) {
        StringBuilder builder = new StringBuilder(String.format("Cannot register %s for type %s because a factory for this type was already registered", entity, publicType.getSimpleName()));
        if (source != null) {
            builder.append(" by ");
            source.describeTo(builder);
        }
        builder.append(".");
        return builder.toString();
    }

    private <S extends T> FactoryRegistration<S> getFactoryRegistration(ModelType<S> type) {
        return (FactoryRegistration)Cast.uncheckedCast(this.factories.get(type.getConcreteClass()));
    }

    private <S extends T> List<InternalViewRegistration> getInternalViewRegistrations(ModelType<S> type) {
        return this.internalViews.get(type.getConcreteClass());
    }

    private <S extends T> ImplementationTypeRegistration<S> getImplementationTypeRegistration(ModelType<S> type) {
        return (ImplementationTypeRegistration)Cast.uncheckedCast(this.implementationTypes.get(type.getConcreteClass()));
    }

    @Override
    public <S extends T> S create(ModelType<S> type, MutableModelNode modelNode, P payload) {
        FactoryRegistration<S> factoryRegistration = this.getFactoryRegistration(type);
        if (factoryRegistration == null) {
            throw new IllegalArgumentException(String.format("Cannot create a %s because this type is not known to %s. Known types are: %s", type.getSimpleName(), this.displayName, this.getSupportedTypeNames()));
        }
        return (S)((FactoryRegistration)factoryRegistration).factory.apply(payload, (Object)modelNode);
    }

    @Override
    public Set<ModelType<? extends T>> getSupportedTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.factories.keySet(), (Function)new Function<Class<? extends T>, ModelType<? extends T>>(){

            public ModelType<? extends T> apply(@Nullable Class<? extends T> input) {
                return ModelType.of(input);
            }
        }));
    }

    private String getSupportedTypeNames() {
        ArrayList names = Lists.newArrayList();
        for (Class<T> clazz : this.factories.keySet()) {
            names.add(clazz.getSimpleName());
        }
        Collections.sort(names);
        return names.isEmpty() ? "(None)" : Joiner.on((String)", ").join((Iterable)names);
    }

    @Override
    public <S extends T> Set<ModelType<?>> getInternalViews(ModelType<S> type) {
        List<InternalViewRegistration> internalViewRegistrations = this.internalViews.get(type.getConcreteClass());
        if (internalViewRegistrations == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(internalViewRegistrations, (Function)new Function<InternalViewRegistration, ModelType<?>>(){

            public ModelType<?> apply(InternalViewRegistration registration) {
                return registration.internalView;
            }
        }));
    }

    @Override
    public void validateRegistrations() {
        for (Class<? extends T> clazz : this.implementationTypes.keySet()) {
            this.validateRegistration(ModelType.of(clazz));
        }
    }

    private <S extends T> void validateRegistration(ModelType<S> publicType) {
        ImplementationTypeRegistration<S> implementationTypeRegistration = this.getImplementationTypeRegistration(publicType);
        List<InternalViewRegistration> internalViewRegistrations = this.getInternalViewRegistrations(publicType);
        if (internalViewRegistrations == null) {
            return;
        }
        ModelType implementation = ((ImplementationTypeRegistration)implementationTypeRegistration).implementationType;
        for (InternalViewRegistration internalViewRegistration : internalViewRegistrations) {
            ModelType internalView = internalViewRegistration.internalView;
            ModelType asSubclass = internalView.asSubclass(implementation);
            if (asSubclass != null) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Factory registration for '%s' is invalid because the implementation type '%s' does not extend internal view '%s'", publicType.getSimpleName(), implementation, internalView));
            if (((ImplementationTypeRegistration)implementationTypeRegistration).source != null) {
                builder.append(". Implementation type was registered by ");
                ((ImplementationTypeRegistration)implementationTypeRegistration).source.describeTo(builder);
            }
            if (internalViewRegistration.source != null) {
                builder.append(". Internal view was registered by ");
                internalViewRegistration.source.describeTo(builder);
            }
            builder.append(".");
            throw new GradleException(builder.toString());
        }
    }

    public String toString() {
        return "[" + this.getSupportedTypeNames() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalViewRegistration {
        private final ModelRuleDescriptor source;
        private final ModelType<?> internalView;

        private InternalViewRegistration(ModelRuleDescriptor source, ModelType<?> internalView) {
            this.source = source;
            this.internalView = internalView;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImplementationTypeRegistration<S extends T> {
        private final ModelRuleDescriptor source;
        private final ModelType<? extends S> implementationType;

        private ImplementationTypeRegistration(ModelRuleDescriptor source, ModelType<? extends S> implementationType) {
            this.source = source;
            this.implementationType = implementationType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryRegistration<S extends T> {
        private final ModelRuleDescriptor source;
        private final BiFunction<? extends S, ? super P, ? super MutableModelNode> factory;

        public FactoryRegistration(ModelRuleDescriptor source, BiFunction<? extends S, ? super P, ? super MutableModelNode> factory) {
            this.source = source;
            this.factory = factory;
        }
    }
}

