/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionNodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeInitializerRegistry
implements NodeInitializerRegistry {
    private final List<NodeInitializerExtractionStrategy> strategies;
    private final ModelSchemaStore schemaStore;

    public DefaultNodeInitializerRegistry(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
        this.strategies = Lists.newArrayList((Object[])new NodeInitializerExtractionStrategy[]{new ModelSetNodeInitializerExtractionStrategy(), new ManagedSetNodeInitializerExtractionStrategy(), new ModelMapNodeInitializerExtractionStrategy(), new ScalarCollectionNodeInitializerExtractionStrategy(), new ManagedImplStructNodeInitializerExtractionStrategy(schemaStore)});
    }

    @Override
    public <T> NodeInitializer getNodeInitializer(ModelSchema<T> schema) {
        for (NodeInitializerExtractionStrategy extractor : this.strategies) {
            NodeInitializer nodeInitializer = extractor.extractNodeInitializer(schema, this);
            if (nodeInitializer == null) continue;
            return nodeInitializer;
        }
        ArrayList supportedTypes = Lists.newArrayList();
        for (NodeInitializerExtractionStrategy extractor : this.strategies) {
            Iterables.addAll((Collection)supportedTypes, extractor.supportedTypes());
        }
        throw new ModelTypeInitializationException(schema.getType(), supportedTypes);
    }

    @Override
    public <T> NodeInitializer getNodeInitializer(ModelType<T> type) {
        return this.getNodeInitializer(this.schemaStore.getSchema(type));
    }

    @Override
    public void registerStrategy(NodeInitializerExtractionStrategy strategy) {
        this.strategies.add(0, strategy);
    }
}

