/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ModelTypeInitializationException
extends GradleException {
    public ModelTypeInitializationException(ModelType<?> type, Iterable<ModelType<?>> candidates) {
        super(ModelTypeInitializationException.toMessage(type, candidates));
    }

    private static String toMessage(ModelType<?> type, Iterable<ModelType<?>> types) {
        return String.format("The model element of type: '%s' can not be constructed. The type must be managed (@Managed) or one of the following types [%s]", type, ModelTypeInitializationException.describe(types));
    }

    private static String describe(Iterable<ModelType<?>> types) {
        return Joiner.on((String)", ").join((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(types, (Function)new Function<ModelType<?>, String>(){

            public String apply(ModelType<?> input) {
                return input.getSimpleName();
            }
        })));
    }
}

