/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import net.jcip.annotations.ThreadSafe;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractModelCreationRuleExtractor
extends AbstractAnnotationDrivenModelRuleExtractor<Model> {
    protected String determineModelName(MethodRuleDefinition<?, ?> ruleDefinition, ModelType<?> type) {
        String modelName;
        boolean hasAnnotationValue;
        String annotationValue = ruleDefinition.getAnnotation(Model.class).value();
        ModelPath servicePath = ModelReference.findServicePath(type);
        boolean bl = hasAnnotationValue = annotationValue == null || annotationValue.isEmpty();
        if (servicePath != null) {
            if (!hasAnnotationValue && !servicePath.toString().equals(annotationValue)) {
                throw new InvalidModelRuleDeclarationException(String.format("Service '%s' must be registered under path '%s' instead of '%s'", type, servicePath, annotationValue));
            }
            modelName = servicePath.getName();
        } else {
            modelName = hasAnnotationValue ? ruleDefinition.getMethodName() : annotationValue;
        }
        try {
            ModelPath.validatePath(modelName);
        }
        catch (Exception e) {
            throw new InvalidModelRuleDeclarationException(String.format("Path of declared model element created by rule %s is invalid.", ruleDefinition.getDescriptor()), (Throwable)e);
        }
        return modelName;
    }
}

