/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.instance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.UncheckedException;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyFactory {
    public static final ManagedProxyFactory INSTANCE = new ManagedProxyFactory();

    public <T> T createProxy(ModelElementState state, ModelManagedImplStructSchema<T> schema) {
        try {
            Class<T> generatedClass = schema.getImplementationType();
            if (generatedClass == null) {
                throw new IllegalStateException("No managed implementation class available for: " + schema.getType());
            }
            Class<?> delegateType = schema.getDelegateType();
            if (delegateType == null) {
                Constructor<T> constructor = generatedClass.getConstructor(ModelElementState.class);
                return constructor.newInstance(state);
            }
            Object delegate = state.getBackingNode().getPrivateData(delegateType);
            Constructor<T> constructor = generatedClass.getConstructor(ModelElementState.class, delegateType);
            return constructor.newInstance(state, delegate);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

