/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.projection;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ManagedImplModelSchema;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    private final ModelSchemaStore schemaStore;
    private final NodeInitializerRegistry nodeInitializerRegistry;
    private final ManagedProxyFactory proxyFactory;
    private final ModelManagedImplStructSchema<M> schema;

    public ManagedModelProjection(ModelManagedImplStructSchema<M> schema, ModelSchemaStore schemaStore, NodeInitializerRegistry nodeInitializerRegistry, ManagedProxyFactory proxyFactory) {
        super(schema.getType(), true, true);
        this.schema = schema;
        this.schemaStore = schemaStore;
        this.proxyFactory = proxyFactory;
        this.nodeInitializerRegistry = nodeInitializerRegistry;
    }

    @Override
    protected ModelView<M> toView(final MutableModelNode modelNode, final ModelRuleDescriptor ruleDescriptor, final boolean writable) {
        return new ModelView<M>(){
            private boolean closed;
            private final Map<String, Object> propertyViews = new HashMap<String, Object>();

            @Override
            public ModelPath getPath() {
                return modelNode.getPath();
            }

            @Override
            public ModelType<M> getType() {
                return ManagedModelProjection.this.getType();
            }

            @Override
            public M getInstance() {
                return ManagedModelProjection.this.proxyFactory.createProxy(new State(), ManagedModelProjection.this.schema);
            }

            @Override
            public void close() {
                this.closed = true;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class State
            implements ModelElementState {
                State() {
                }

                @Override
                public MutableModelNode getBackingNode() {
                    return modelNode;
                }

                @Override
                public String getDisplayName() {
                    return String.format("%s '%s'", this.getType(), modelNode.getPath().toString());
                }

                @Override
                public Object get(String name) {
                    if (propertyViews.containsKey(name)) {
                        return propertyViews.get(name);
                    }
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    Object value = this.doGet(property, name);
                    propertyViews.put(name, value);
                    return value;
                }

                private <T> T doGet(ModelProperty<T> property, String propertyName) {
                    ModelView<T> modelView;
                    Collection instance;
                    ModelType<T> propertyType = property.getType();
                    MutableModelNode propertyNode = modelNode.getLink(propertyName);
                    propertyNode.ensureUsable();
                    ModelSchema<T> propertySchema = ManagedModelProjection.this.schemaStore.getSchema(propertyType);
                    if (property.isWritable() && propertySchema instanceof ScalarCollectionSchema && (instance = ScalarCollectionSchema.get(propertyNode)) == null) {
                        return null;
                    }
                    if (writable) {
                        modelView = propertyNode.asWritable(propertyType, ruleDescriptor, null);
                        if (closed) {
                            modelView.close();
                        }
                    } else {
                        modelView = propertyNode.asReadOnly(propertyType, ruleDescriptor);
                    }
                    return modelView.getInstance();
                }

                @Override
                public void set(String name, Object value) {
                    if (!writable || closed) {
                        throw new ModelViewClosedException(this.getType(), ruleDescriptor);
                    }
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    ModelType<?> propertyType = property.getType();
                    value = this.doSet(name, value, propertyType);
                    propertyViews.put(name, value);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                private <T> Object doSet(String name, Object value, ModelType<T> propertyType) {
                    ModelSchema<T> propertySchema = ManagedModelProjection.this.schemaStore.getSchema(propertyType);
                    MutableModelNode propertyNode = modelNode.getLink(name);
                    propertyNode.ensureUsable();
                    if (!(propertySchema instanceof ManagedImplModelSchema)) {
                        Object castValue = Cast.uncheckedCast((Object)value);
                        propertyNode.setPrivateData(propertyType, castValue);
                        return value;
                    }
                    if (value == null) {
                        if (propertySchema instanceof ScalarCollectionSchema) {
                            ScalarCollectionSchema.clear(propertyNode);
                            return value;
                        }
                        propertyNode.setTarget(null);
                        return value;
                    }
                    if (ManagedInstance.class.isInstance(value)) {
                        ManagedInstance managedInstance = (ManagedInstance)value;
                        MutableModelNode targetNode = managedInstance.getBackingNode();
                        propertyNode.setTarget(targetNode);
                        return value;
                    }
                    if (propertySchema instanceof ScalarCollectionSchema && Collection.class.isInstance(value)) {
                        Collection values = (Collection)Cast.uncheckedCast((Object)value);
                        ScalarCollectionSchema scalarSchema = (ScalarCollectionSchema)Cast.uncheckedCast(propertySchema);
                        return this.initializeCollection(propertyNode, propertyType, scalarSchema, values);
                    }
                    throw new IllegalArgumentException(String.format("Only managed model instances can be set as property '%s' of class '%s'", name, this.getType()));
                }

                private <T, E> Object initializeCollection(MutableModelNode propertyNode, ModelType<T> propertyType, ScalarCollectionSchema<T, E> propertySchema, Collection<E> value) {
                    ScalarCollectionSchema.clear(propertyNode);
                    NodeInitializer initializer = ManagedModelProjection.this.nodeInitializerRegistry.getNodeInitializer(propertySchema);
                    List<? extends ModelProjection> projections = initializer.getProjections();
                    for (ModelProjection modelProjection : projections) {
                        ModelView<T> modelView = modelProjection.asMutable(propertyType, propertyNode, ruleDescriptor, null);
                        if (modelView == null) continue;
                        Collection instance = (Collection)Cast.uncheckedCast(modelView.getInstance());
                        instance.addAll(value);
                        return instance;
                    }
                    return null;
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && super.equals(o);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        return Optional.absent();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

