/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelProperty<T> {
    private final String name;
    private final ModelType<T> type;
    private final StateManagementType stateManagementType;
    private final boolean writable;
    private final Set<ModelType<?>> declaredBy;
    private final List<WeaklyTypeReferencingMethod<?, T>> getters;
    private final boolean declaredAsHavingUnmanagedType;

    private ModelProperty(ModelType<T> type, String name, StateManagementType stateManagementType, boolean writable, Set<ModelType<?>> declaredBy, List<WeaklyTypeReferencingMethod<?, T>> getters, boolean declaredAsHavingUnmanagedType) {
        this.name = name;
        this.type = type;
        this.stateManagementType = stateManagementType;
        this.writable = writable;
        this.declaredBy = ImmutableSet.copyOf(declaredBy);
        this.getters = ImmutableList.copyOf(getters);
        this.declaredAsHavingUnmanagedType = declaredAsHavingUnmanagedType;
    }

    public static <T> ModelProperty<T> of(ModelType<T> type, String name, StateManagementType stateManagementType, boolean writable, Set<ModelType<?>> declaredBy, List<WeaklyTypeReferencingMethod<?, T>> getters, boolean declaredAsHavingUnmanagedType) {
        return new ModelProperty<T>(type, name, stateManagementType, writable, declaredBy, getters, declaredAsHavingUnmanagedType);
    }

    public String getName() {
        return this.name;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public StateManagementType getStateManagementType() {
        return this.stateManagementType;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Set<ModelType<?>> getDeclaredBy() {
        return this.declaredBy;
    }

    private WeaklyTypeReferencingMethod<?, T> firstGetter() {
        return this.getters.get(0);
    }

    public List<WeaklyTypeReferencingMethod<?, T>> getGetters() {
        return this.getters;
    }

    public <I> T getPropertyValue(I instance) {
        return (T)((WeaklyTypeReferencingMethod)Cast.uncheckedCast(this.firstGetter())).invoke(instance, new Object[0]);
    }

    public boolean isDeclaredAsHavingUnmanagedType() {
        return this.declaredAsHavingUnmanagedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.type, that.type) && Objects.equal((Object)((Object)this.stateManagementType), (Object)((Object)that.stateManagementType)) && this.declaredAsHavingUnmanagedType == that.declaredAsHavingUnmanagedType && this.writable == that.writable;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.stateManagementType.hashCode();
        result = 31 * result + Boolean.valueOf(this.writable).hashCode();
        result = 31 * result + Boolean.valueOf(this.declaredAsHavingUnmanagedType).hashCode();
        return result;
    }

    public String toString() {
        return this.stateManagementType.name().toLowerCase() + " " + this.getName() + "(" + this.getType().getSimpleName() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateManagementType {
        MANAGED,
        UNMANAGED,
        DELEGATED;

    }
}

