/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.SystemProperties;
import org.gradle.model.Managed;
import org.gradle.model.ModelMap;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.EnumStrategy;
import org.gradle.model.internal.manage.schema.extract.JdkValueTypeStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedSetStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSetStrategy;
import org.gradle.model.internal.manage.schema.extract.PrimitiveStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapStrategy;
import org.gradle.model.internal.manage.schema.extract.UnmanagedImplStructStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelSchemaExtractor {
    private final List<? extends ModelSchemaExtractionStrategy> strategies;

    public ModelSchemaExtractor() {
        this(Collections.emptyList(), new ModelSchemaAspectExtractor());
    }

    public ModelSchemaExtractor(List<? extends ModelSchemaExtractionStrategy> strategies, ModelSchemaAspectExtractor aspectExtractor) {
        this.strategies = ImmutableList.builder().addAll(strategies).add((Object)new PrimitiveStrategy()).add((Object)new EnumStrategy()).add((Object)new JdkValueTypeStrategy()).add((Object)new ModelSetStrategy()).add((Object)new ManagedSetStrategy()).add((Object)new SpecializedMapStrategy()).add((Object)new ModelMapStrategy()).add((Object)new ScalarCollectionStrategy()).add((Object)new ManagedImplStructStrategy(aspectExtractor)).add((Object)new UnmanagedImplStructStrategy(aspectExtractor)).build();
    }

    public <T> ModelSchema<T> extract(ModelType<T> type, ModelSchemaStore store, ModelSchemaCache cache) {
        ModelSchemaExtractionContext context = ModelSchemaExtractionContext.root(type);
        LinkedList validations = Lists.newLinkedList();
        LinkedList unsatisfiedDependencies = Lists.newLinkedList();
        ModelSchemaExtractionContext extractionContext = context;
        validations.add(extractionContext);
        while (extractionContext != null) {
            this.extractSchema(extractionContext, store, cache);
            List<ModelSchemaExtractionContext<?>> dependencies = extractionContext.getChildren();
            Iterables.addAll((Collection)validations, dependencies);
            this.pushUnsatisfiedDependencies(dependencies, unsatisfiedDependencies, cache);
            extractionContext = (ModelSchemaExtractionContext)unsatisfiedDependencies.poll();
        }
        for (ModelSchemaExtractionContext validationContext : Lists.reverse((List)validations)) {
            this.validate(validationContext, cache);
        }
        return context.getResult();
    }

    private void pushUnsatisfiedDependencies(Iterable<? extends ModelSchemaExtractionContext<?>> allDependencies, Queue<ModelSchemaExtractionContext<?>> dependencyQueue, final ModelSchemaCache cache) {
        Iterables.addAll(dependencyQueue, (Iterable)Iterables.filter(allDependencies, (Predicate)new Predicate<ModelSchemaExtractionContext<?>>(){

            public boolean apply(ModelSchemaExtractionContext<?> dependency) {
                return cache.get(dependency.getType()) == null;
            }
        }));
    }

    private <T> void validate(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        extractionContext.validate(cache.get(extractionContext.getType()));
    }

    private <T> void extractSchema(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaStore store, ModelSchemaCache cache) {
        ModelType<T> type = extractionContext.getType();
        ModelSchema<T> cached = cache.get(type);
        if (cached != null) {
            extractionContext.found(cached);
            return;
        }
        for (ModelSchemaExtractionStrategy modelSchemaExtractionStrategy : this.strategies) {
            modelSchemaExtractionStrategy.extract(extractionContext, store);
            if (extractionContext.getResult() == null) continue;
            cache.set(type, extractionContext.getResult());
            return;
        }
        throw new IllegalStateException("No extraction strategy found for type: " + type);
    }

    public static String getManageablePropertyTypesDescription() {
        return Joiner.on((String)SystemProperties.getInstance().getLineSeparator()).join(Iterables.transform(ModelSchemaExtractor.getSupportedTypes(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return " - " + input;
            }
        }));
    }

    private static Iterable<String> getSupportedTypes() {
        return ImmutableList.builder().add((Object)String.format("interfaces and abstract classes annotated with %s", Managed.class.getName())).addAll(ScalarTypes.getSupported()).add((Object)String.format("%s of a managed type", ModelMap.class.getName())).add((Object)String.format("%s of a managed type", ModelSet.class.getName())).build();
    }
}

