/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelSet;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.TypedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ManagedChildNodeCreatorStrategy;
import org.gradle.model.internal.inspect.ProjectionOnlyNodeInitializer;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSetNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    private static final ModelType<ModelSet<?>> MODEL_SET_MODEL_TYPE = new ModelType<ModelSet<?>>(){};

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(ModelCollectionSchema<T, E> schema, NodeInitializerRegistry nodeInitializerRegistry) {
        if (MODEL_SET_MODEL_TYPE.isAssignableFrom(schema.getType())) {
            ModelProjection projection = TypedModelProjection.of(ModelTypes.modelSet(schema.getElementType()), new ModelSetModelViewFactory<E>(schema.getElementType(), nodeInitializerRegistry));
            return new ProjectionOnlyNodeInitializer(projection);
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.of(MODEL_SET_MODEL_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelSetModelViewFactory<T>
    implements ModelViewFactory<ModelSet<T>> {
        private final ModelType<T> elementType;
        private final NodeInitializerRegistry nodeInitializerRegistry;

        public ModelSetModelViewFactory(ModelType<T> elementType, NodeInitializerRegistry nodeInitializerRegistry) {
            this.elementType = elementType;
            this.nodeInitializerRegistry = nodeInitializerRegistry;
        }

        @Override
        public ModelView<ModelSet<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
            ModelType<ModelSet<T>> setType = ModelTypes.modelSet(this.elementType);
            DefaultModelViewState state = new DefaultModelViewState(setType, ruleDescriptor, writable, !writable);
            ManagedChildNodeCreatorStrategy childCreator = new ManagedChildNodeCreatorStrategy(this.nodeInitializerRegistry);
            NodeBackedModelSet<T> set = new NodeBackedModelSet<T>(setType.toString() + " '" + modelNode.getPath() + "'", this.elementType, ruleDescriptor, modelNode, state, childCreator);
            return InstanceModelView.of(modelNode.getPath(), setType, set, state.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelSetModelViewFactory that = (ModelSetModelViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }
}

