/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import org.gradle.api.Action;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.CollectionStrategy;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetStrategy
extends CollectionStrategy {
    private final ModelType<?> modelType;

    public SetStrategy(ModelType<?> modelType) {
        this.modelType = modelType;
    }

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaStore store) {
        ModelType<T> type = extractionContext.getType();
        if (this.modelType.isAssignableFrom(type)) {
            this.validateType(this.modelType, extractionContext, type);
            ModelType<?> elementType = type.getTypeVariables().get(0);
            extractionContext.found(this.getModelSchema(this.modelType, extractionContext, elementType));
        }
    }

    protected <T, E> ModelSchema<T> getModelSchema(ModelType<?> modelType, ModelSchemaExtractionContext<T> extractionContext, ModelType<E> elementType) {
        if (modelType.isAssignableFrom(elementType)) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("%1$s cannot be used as type parameter of %1$s", modelType.getConcreteClass().getName()));
        }
        ModelCollectionSchema<T, E> schema = new ModelCollectionSchema<T, E>(extractionContext.getType(), elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            public void execute(ModelSchema<E> typeParamSchema) {
            }
        });
        return schema;
    }
}

