/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.delete;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.UnableToDeleteFileException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.delete.DefaultDeleteSpec;
import org.gradle.api.internal.file.delete.DeleteSpecInternal;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deleter {
    private static Logger logger = LoggerFactory.getLogger(Deleter.class);
    private FileResolver fileResolver;
    private FileSystem fileSystem;
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;

    public Deleter(FileResolver fileResolver, FileSystem fileSystem) {
        this.fileResolver = fileResolver;
        this.fileSystem = fileSystem;
    }

    public boolean delete(Object ... paths) {
        final Object[] innerPaths = paths;
        return this.delete((Action<? super DeleteSpec>)new Action<DeleteSpec>(){

            public void execute(DeleteSpec deleteSpec) {
                deleteSpec.delete(innerPaths).setFollowSymlinks(false);
            }
        }).getDidWork();
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        boolean didWork = false;
        DefaultDeleteSpec deleteSpec = new DefaultDeleteSpec();
        action.execute((Object)deleteSpec);
        Object[] paths = deleteSpec.getPaths();
        for (File file : this.fileResolver.resolveFiles(paths)) {
            if (!file.exists()) continue;
            logger.debug("Deleting {}", (Object)file);
            didWork = true;
            this.doDeleteInternal(file, deleteSpec);
        }
        return new SimpleWorkResult(didWork);
    }

    private void doDeleteInternal(File file, DeleteSpecInternal deleteSpec) {
        if (file.isDirectory() && (deleteSpec.isFollowSymlinks() || !this.fileSystem.isSymlink(file))) {
            File[] contents = file.listFiles();
            if (contents == null) {
                return;
            }
            for (File item : contents) {
                this.doDeleteInternal(item, deleteSpec);
            }
        }
        if (!file.delete() && file.exists()) {
            this.handleFailedDelete(file);
        }
    }

    private boolean isRunGcOnFailedDelete() {
        return OperatingSystem.current().isWindows();
    }

    private void handleFailedDelete(File file) {
        if (this.isRunGcOnFailedDelete()) {
            System.gc();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!file.delete() && file.exists()) {
            throw new UnableToDeleteFileException(file);
        }
    }
}

