/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaJvmAssembly;
import org.gradle.language.scala.internal.DefaultScalaLanguageSourceSet;
import org.gradle.language.scala.internal.ScalaJvmAssembly;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.play.JvmClasses;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlayApplicationBinarySpec
extends BaseBinarySpec
implements PlayApplicationBinarySpecInternal {
    private final DefaultScalaJvmAssembly jvmAssembly = new DefaultScalaJvmAssembly(this.getIdentifier().child("assembly"));
    private final PublicAssets assets = new DefaultPublicAssets(this.getIdentifier().child("publicAssets"));
    private Map<LanguageSourceSet, ScalaLanguageSourceSet> generatedScala = Maps.newHashMap();
    private Map<LanguageSourceSet, JavaScriptSourceSet> generatedJavaScript = Maps.newHashMap();
    private PlayPlatform platform;
    private PlayToolChainInternal toolChain;
    private File jarFile;
    private File assetsJarFile;
    private FileCollection classpath;

    protected String getTypeName() {
        return "Play Application Jar";
    }

    @Override
    public PlayApplicationSpec getApplication() {
        return (PlayApplicationSpec)this.getComponentAs(PlayApplicationSpec.class);
    }

    @Override
    public PlayPlatform getTargetPlatform() {
        return this.platform;
    }

    @Override
    public PlayToolChainInternal getToolChain() {
        return this.toolChain;
    }

    @Override
    public ScalaJvmAssembly getAssembly() {
        return this.jvmAssembly;
    }

    @Override
    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public void setTargetPlatform(PlayPlatform platform) {
        this.platform = platform;
        this.jvmAssembly.setTargetPlatform(platform.getJavaPlatform());
        this.jvmAssembly.setScalaPlatform(platform.getScalaPlatform());
    }

    @Override
    public void setToolChain(PlayToolChainInternal toolChain) {
        this.toolChain = toolChain;
    }

    @Override
    public void setJarFile(File file) {
        this.jarFile = file;
    }

    @Override
    public File getAssetsJarFile() {
        return this.assetsJarFile;
    }

    @Override
    public void setAssetsJarFile(File assetsJarFile) {
        this.assetsJarFile = assetsJarFile;
    }

    @Override
    public JvmClasses getClasses() {
        return new JvmClassesAdapter((JvmAssembly)this.jvmAssembly);
    }

    @Override
    public PublicAssets getAssets() {
        return this.assets;
    }

    @Override
    public Map<LanguageSourceSet, ScalaLanguageSourceSet> getGeneratedScala() {
        return this.generatedScala;
    }

    @Override
    public void addGeneratedScala(LanguageSourceSet input, SourceDirectorySetFactory sourceDirectorySetFactory) {
        String lssName = String.format("%sScalaSources", input.getName());
        ScalaLanguageSourceSet generatedScalaSources = (ScalaLanguageSourceSet)BaseLanguageSourceSet.create(ScalaLanguageSourceSet.class, DefaultScalaLanguageSourceSet.class, (ComponentSpecIdentifier)this.getIdentifier().child(lssName), (SourceDirectorySetFactory)sourceDirectorySetFactory);
        generatedScalaSources.builtBy(new Object[0]);
        this.generatedScala.put(input, generatedScalaSources);
    }

    @Override
    public Map<LanguageSourceSet, JavaScriptSourceSet> getGeneratedJavaScript() {
        return this.generatedJavaScript;
    }

    @Override
    public void addGeneratedJavaScript(LanguageSourceSet input, SourceDirectorySetFactory sourceDirectorySetFactory) {
        String lssName = String.format("%sJavaScript", input.getName());
        JavaScriptSourceSet javaScript = (JavaScriptSourceSet)BaseLanguageSourceSet.create(JavaScriptSourceSet.class, DefaultJavaScriptSourceSet.class, (ComponentSpecIdentifier)this.getIdentifier().child(lssName), (SourceDirectorySetFactory)sourceDirectorySetFactory);
        javaScript.builtBy(new Object[0]);
        this.generatedJavaScript.put(input, javaScript);
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public BinaryBuildAbility getBinaryBuildAbility() {
        return new ToolSearchBuildAbility((ToolSearchResult)this.getToolChain().select(this.getTargetPlatform()));
    }

    public boolean hasCodependentSources() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPublicAssets
    extends AbstractBuildableComponentSpec
    implements PublicAssets {
        private Set<File> resourceDirs = Sets.newLinkedHashSet();

        public DefaultPublicAssets(ComponentSpecIdentifier identifier) {
            super(identifier, PublicAssets.class);
        }

        @Override
        public Set<File> getAssetDirs() {
            return this.resourceDirs;
        }

        @Override
        public void addAssetDir(File assetDir) {
            this.resourceDirs.add(assetDir);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmClassesAdapter
    implements JvmClasses {
        private final JvmAssembly jvmAssembly;

        private JvmClassesAdapter(JvmAssembly jvmAssembly) {
            this.jvmAssembly = jvmAssembly;
        }

        public String getDisplayName() {
            return this.jvmAssembly.getDisplayName();
        }

        public String getProjectPath() {
            return this.jvmAssembly.getProjectPath();
        }

        public String getName() {
            return this.jvmAssembly.getName();
        }

        @Override
        public File getClassesDir() {
            return (File)CollectionUtils.single((Iterable)this.jvmAssembly.getClassDirectories());
        }

        @Override
        public void setClassesDir(File classesDir) {
            BaseBinarySpec.replaceSingleDirectory((Set)this.jvmAssembly.getClassDirectories(), (File)classesDir);
        }

        @Override
        public Set<File> getResourceDirs() {
            return this.jvmAssembly.getResourceDirectories();
        }

        @Override
        public void addResourceDir(File resourceDir) {
            this.jvmAssembly.getResourceDirectories().add(resourceDir);
        }

        public void builtBy(Object ... tasks) {
            this.jvmAssembly.builtBy(tasks);
        }

        @Nullable
        public Task getBuildTask() {
            return this.jvmAssembly.getBuildTask();
        }

        public void setBuildTask(Task lifecycleTask) {
            this.jvmAssembly.setBuildTask(lifecycleTask);
        }

        public boolean hasBuildDependencies() {
            return this.jvmAssembly.hasBuildDependencies();
        }

        public TaskDependency getBuildDependencies() {
            return this.jvmAssembly.getBuildDependencies();
        }
    }
}

