/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.messaging.dispatch.DispatchException;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTrackingFailureHandler
implements DispatchFailureHandler<Object>,
Stoppable {
    private final Logger logger;
    private DispatchException failure;

    public ExceptionTrackingFailureHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void dispatchFailed(Object message, Throwable failure) {
        if (this.failure != null) {
            this.logger.error(failure.getMessage(), failure);
        } else {
            this.failure = new DispatchException(String.format("Could not dispatch message %s.", message), failure);
        }
    }

    public void stop() throws DispatchException {
        if (this.failure != null) {
            try {
                throw this.failure;
            }
            catch (Throwable throwable) {
                this.failure = null;
                throw throwable;
            }
        }
    }
}

