/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.jshint;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.plugins.javascript.jshint.internal.JsHintProtocol;
import org.gradle.plugins.javascript.jshint.internal.JsHintResult;
import org.gradle.plugins.javascript.jshint.internal.JsHintSpec;
import org.gradle.plugins.javascript.jshint.internal.JsHintWorker;
import org.gradle.plugins.javascript.rhino.worker.internal.DefaultRhinoWorkerHandleFactory;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessFactory;

public class JsHint
extends SourceTask {
    private Object rhinoClasspath;
    private Object jsHint;
    private String encoding = "UTF-8";
    private Object jsonReport;

    @Inject
    protected WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @InputFiles
    public FileCollection getRhinoClasspath() {
        return this.getProject().files(new Object[]{this.rhinoClasspath});
    }

    public void setRhinoClasspath(Object rhinoClasspath) {
        this.rhinoClasspath = rhinoClasspath;
    }

    @InputFiles
    public FileCollection getJsHint() {
        return this.getProject().files(new Object[]{this.jsHint});
    }

    public void setJsHint(Object jsHint) {
        this.jsHint = jsHint;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @OutputFile
    public File getJsonReport() {
        return this.jsonReport == null ? null : this.getProject().file(this.jsonReport);
    }

    public void setJsonReport(Object jsonReport) {
        this.jsonReport = jsonReport;
    }

    @TaskAction
    public void doJsHint() {
        DefaultRhinoWorkerHandleFactory handleFactory = new DefaultRhinoWorkerHandleFactory(this.getWorkerProcessBuilderFactory());
        LogLevel logLevel = this.getProject().getGradle().getStartParameter().getLogLevel();
        JsHintProtocol worker = handleFactory.create((Iterable<File>)this.getRhinoClasspath(), JsHintProtocol.class, JsHintWorker.class, logLevel, new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.setWorkingDir((Object)JsHint.this.getProject().getProjectDir());
            }
        });
        JsHintSpec spec = new JsHintSpec();
        spec.setSource(this.getSource().getFiles());
        spec.setEncoding(this.getEncoding());
        spec.setJsHint(this.getJsHint().getSingleFile());
        JsHintResult result = worker.process(spec);
        this.setDidWork(true);
        Logger logger = this.getLogger();
        boolean anyErrors = false;
        LinkedHashMap<String, Map<String, Object>> reportData = new LinkedHashMap<String, Map<String, Object>>(result.getResults().size());
        for (Map.Entry<File, Map<String, Object>> fileEntry : result.getResults().entrySet()) {
            File file = fileEntry.getKey();
            Map<String, Object> data = fileEntry.getValue();
            reportData.put(file.getAbsolutePath(), data);
            if (!data.containsKey("errors")) continue;
            anyErrors = true;
            URI projectDirUri = this.getProject().getProjectDir().toURI();
            Map errors = (Map)data.get("errors");
            if (errors.isEmpty()) continue;
            URI relativePath = projectDirUri.relativize(file.toURI());
            logger.warn("JsHint errors for file: {}", (Object)relativePath.getPath());
            for (Map.Entry errorEntry : errors.entrySet()) {
                Map error = (Map)errorEntry.getValue();
                int line = Float.valueOf(error.get("line").toString()).intValue();
                int character = Float.valueOf(error.get("character").toString()).intValue();
                String reason = error.get("reason").toString();
                logger.warn("  {}:{} > {}", new Object[]{line, character, reason});
            }
        }
        File jsonReportFile = this.getJsonReport();
        if (jsonReportFile != null) {
            try {
                FileWriter reportWriter = new FileWriter(jsonReportFile);
                new GsonBuilder().setPrettyPrinting().create().toJson(reportData, (Appendable)reportWriter);
                reportWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (anyErrors) {
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException("JsHint detected errors"));
        }
    }
}

