/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;

public class EnvConfiguration
implements Configuration {
    private WebAppContext webAppContext;
    private Context compCtx;
    private Context envCtx;
    private URL jettyEnvXmlUrl;

    protected void createEnvContext() throws NamingException {
        InitialContext context = new InitialContext();
        this.compCtx = (Context)context.lookup("java:comp");
        this.envCtx = this.compCtx.createSubcontext("env");
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Created java:comp/env for webapp " + this.getWebAppContext().getContextPath()));
        }
    }

    public void setWebAppContext(WebAppContext context) {
        this.webAppContext = context;
    }

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlUrl = url;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
        this.createEnvContext();
    }

    public void configureWebApp() throws Exception {
        Resource jettyEnv;
        Resource web_inf;
        if (this.jettyEnvXmlUrl == null && (web_inf = this.getWebAppContext().getWebInf()) != null && web_inf.isDirectory() && (jettyEnv = web_inf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = jettyEnv.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlUrl);
            configuration.configure((Object)this.getWebAppContext());
        }
        this.bindEnvEntries();
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppContext.getClassLoader());
        this.compCtx.destroySubcontext("env");
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(this.getWebAppContext());
            scopeContext.destroySubcontext("__");
        }
        catch (NameNotFoundException e) {
            Log.ignore((Throwable)e);
            Log.debug((String)("No naming entries configured in environment for webapp " + this.getWebAppContext()));
        }
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void bindEnvEntries() throws NamingException {
        Name namingEntryName;
        EnvEntry ee;
        Log.debug((String)"Binding env entries from the jvm scope");
        Server scope = null;
        List list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            ee = (EnvEntry)itor.next();
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind((Context)this.envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
        Log.debug((String)"Binding env entries from the server scope");
        scope = this.getWebAppContext().getServer();
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        itor = list.iterator();
        while (itor.hasNext()) {
            ee = (EnvEntry)itor.next();
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind((Context)this.envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
        Log.debug((String)"Binding env entries from the context scope");
        scope = this.getWebAppContext();
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        itor = list.iterator();
        while (itor.hasNext()) {
            ee = (EnvEntry)itor.next();
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind((Context)this.envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
    }
}

