/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;

public class ReportingExtension {
    public static final String NAME = "reporting";
    public static final String DEFAULT_REPORTS_DIR_NAME = "reports";
    private final ProjectInternal project;
    private Object baseDir;

    public ReportingExtension(Project project) {
        this.project = (ProjectInternal)project;
        this.baseDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ((FileLookup)ReportingExtension.this.project.getServices().get(FileLookup.class)).getFileResolver(ReportingExtension.this.project.getBuildDir()).resolve((Object)ReportingExtension.DEFAULT_REPORTS_DIR_NAME);
            }
        };
    }

    public File getBaseDir() {
        return this.project.file(this.baseDir);
    }

    public void setBaseDir(Object baseDir) {
        this.baseDir = baseDir;
    }

    public File file(String path) {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver(this.getBaseDir()).resolve((Object)path);
    }

    public String getApiDocTitle() {
        Object version = this.project.getVersion();
        if ("unspecified".equals(version)) {
            return String.format("%s API", this.project.getName());
        }
        return String.format("%s %s API", this.project.getName(), version);
    }
}

