/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.com.google.common.collect;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.testkit.jarjar.com.google.common.annotations.GwtCompatible;
import org.gradle.testkit.jarjar.com.google.common.base.Function;
import org.gradle.testkit.jarjar.com.google.common.base.Predicate;
import org.gradle.testkit.jarjar.com.google.common.collect.MapMaker;
import org.gradle.testkit.jarjar.com.google.common.collect.Maps;
import org.gradle.testkit.jarjar.com.google.common.collect.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
final class Platform {
    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Sets.newSetFromMap(map);
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <K, V1, V2> SortedMap<K, V2> mapsTransformEntriesSortedMap(SortedMap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        return Maps.transformEntriesIgnoreNavigable(fromMap, transformer);
    }

    static <K, V> SortedMap<K, V> mapsAsMapSortedSet(SortedSet<K> set, Function<? super K, V> function) {
        return Maps.asMapSortedIgnoreNavigable(set, function);
    }

    static <E> SortedSet<E> setsFilterSortedSet(SortedSet<E> set, Predicate<? super E> predicate) {
        return Sets.filterSortedIgnoreNavigable(set, predicate);
    }

    static <K, V> SortedMap<K, V> mapsFilterSortedMap(SortedMap<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
        return Maps.filterSortedIgnoreNavigable(map, predicate);
    }

    private Platform() {
    }
}

