/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.groovy.scripts;

import java.io.File;
import java.net.URI;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.AbstractUriScriptSource;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.NonExistentFileScriptSource;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.ScriptSource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.ResourceLocation;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.TextResource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.UriTextResource;

public class UriScriptSource
extends AbstractUriScriptSource {
    private final TextResource resource;

    public static ScriptSource file(String description, File sourceFile) {
        if (sourceFile.exists()) {
            return new UriScriptSource(description, sourceFile);
        }
        return new NonExistentFileScriptSource(description, sourceFile);
    }

    public UriScriptSource(String description, File sourceFile) {
        this.resource = new UriTextResource(description, sourceFile);
    }

    public UriScriptSource(String description, URI sourceUri) {
        this.resource = new UriTextResource(description, sourceUri);
    }

    public TextResource getResource() {
        return this.resource;
    }

    public String getFileName() {
        ResourceLocation location = this.resource.getLocation();
        File sourceFile = location.getFile();
        URI sourceUri = location.getURI();
        return sourceFile != null ? sourceFile.getPath() : sourceUri.toString();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }
}

