/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.ResourceConnectorRepositoryTransport;
import org.gradle.internal.resource.transport.file.FileTransport;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.BuildCommencedTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTransportFactory {
    private final List<ResourceConnectorFactory> registeredProtocols = Lists.newArrayList();
    private final TemporaryFileProvider temporaryFileProvider;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;

    public RepositoryTransportFactory(Collection<ResourceConnectorFactory> resourceConnectorFactory, ProgressLoggerFactory progressLoggerFactory, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
        for (ResourceConnectorFactory connectorFactory : resourceConnectorFactory) {
            this.register(connectorFactory);
        }
    }

    public void register(ResourceConnectorFactory resourceConnectorFactory) {
        this.registeredProtocols.add(resourceConnectorFactory);
    }

    public Set<String> getRegisteredProtocols() {
        LinkedHashSet validSchemes = Sets.newLinkedHashSet();
        for (ResourceConnectorFactory registeredProtocol : this.registeredProtocols) {
            validSchemes.addAll(registeredProtocol.getSupportedProtocols());
        }
        return validSchemes;
    }

    public RepositoryTransport createTransport(String scheme, String name, Collection<Authentication> authentications) {
        return this.createTransport(Collections.singleton(scheme), name, authentications);
    }

    public RepositoryTransport createTransport(Set<String> schemes, String name, Collection<Authentication> authentications) {
        this.validateSchemes(schemes);
        ResourceConnectorFactory connectorFactory = this.findConnectorFactory(schemes);
        this.validateConnectorFactoryCredentials(schemes, connectorFactory, authentications);
        if (Collections.singleton("file").containsAll(schemes)) {
            return new FileTransport(name);
        }
        DefaultResourceConnectorSpecification connectionDetails = new DefaultResourceConnectorSpecification(authentications);
        ExternalResourceConnector resourceConnector = connectorFactory.createResourceConnector((ResourceConnectorSpecification)connectionDetails);
        return new ResourceConnectorRepositoryTransport(name, this.progressLoggerFactory, this.temporaryFileProvider, this.cachedExternalResourceIndex, this.timeProvider, this.cacheLockingManager, resourceConnector);
    }

    private void validateSchemes(Set<String> schemes) {
        Set<String> validSchemes = this.getRegisteredProtocols();
        for (String scheme : schemes) {
            if (validSchemes.contains(scheme)) continue;
            throw new InvalidUserDataException(String.format("Not a supported repository protocol '%s': valid protocols are %s", scheme, validSchemes));
        }
    }

    private void validateConnectorFactoryCredentials(Set<String> schemes, ResourceConnectorFactory factory, Collection<Authentication> authentications) {
        HashSet configuredAuthenticationTypes = Sets.newHashSet();
        for (Authentication authentication : authentications) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            boolean isAuthenticationSupported = false;
            Credentials credentials = authenticationInternal.getCredentials();
            for (Class authenticationType : factory.getSupportedAuthentication()) {
                if (!authenticationType.isAssignableFrom(authentication.getClass())) continue;
                isAuthenticationSupported = true;
                break;
            }
            if (!isAuthenticationSupported) {
                throw new InvalidUserDataException(String.format("Authentication scheme %s is not supported by protocol '%s'", authentication, schemes.iterator().next()));
            }
            if (credentials != null) {
                if (!((AuthenticationInternal)authentication).supports(credentials)) {
                    throw new InvalidUserDataException(String.format("Credentials type of '%s' is not supported by authentication scheme %s", credentials.getClass().getSimpleName(), authentication));
                }
            } else {
                throw new InvalidUserDataException("You cannot configure authentication schemes for a repository if no credentials are provided.");
            }
            if (configuredAuthenticationTypes.add(authenticationInternal.getType())) continue;
            throw new InvalidUserDataException(String.format("You cannot configure multiple authentication schemes of the same type.  The duplicate one is %s.", authentication));
        }
    }

    private ResourceConnectorFactory findConnectorFactory(Set<String> schemes) {
        for (ResourceConnectorFactory protocolRegistration : this.registeredProtocols) {
            if (!protocolRegistration.getSupportedProtocols().containsAll(schemes)) continue;
            return protocolRegistration;
        }
        throw new InvalidUserDataException("You cannot mix different URL schemes for a single repository. Please declare separate repositories.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultResourceConnectorSpecification
    implements ResourceConnectorSpecification {
        private final Collection<Authentication> authentications;

        private DefaultResourceConnectorSpecification(Collection<Authentication> authentications) {
            this.authentications = authentications;
        }

        public <T> T getCredentials(Class<T> type) {
            if (this.authentications == null || this.authentications.size() < 1) {
                return null;
            }
            Credentials credentials = ((AuthenticationInternal)this.authentications.iterator().next()).getCredentials();
            if (credentials == null) {
                return null;
            }
            if (type.isAssignableFrom(credentials.getClass())) {
                return type.cast(credentials);
            }
            throw new IllegalArgumentException(String.format("Credentials must be an instance of '%s'.", type.getCanonicalName()));
        }

        public Collection<Authentication> getAuthentications() {
            return this.authentications;
        }
    }
}

