/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.impldeps;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.impldeps.GradleImplDepsRelocator;
import org.gradle.api.internal.impldeps.RelocatedJarCreator;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.progress.PercentageProgressFormatter;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.GFileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleImplDepsRelocatedJarCreator
implements RelocatedJarCreator {
    private static final int BUFFER_SIZE = 8192;
    private static final String SERVICES_DIR_PREFIX = "META-INF/services/";
    private static final int ADDITIONAL_PROGRESS_STEPS = 2;
    private static final GradleImplDepsRelocator REMAPPER = new GradleImplDepsRelocator();
    private final ProgressLoggerFactory progressLoggerFactory;

    public GradleImplDepsRelocatedJarCreator(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(File outputJar, Iterable<? extends File> files) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(GradleImplDepsRelocatedJarCreator.class);
        progressLogger.setDescription("Gradle JARs generation");
        progressLogger.setLoggingHeader(String.format("Generating JAR file '%s'", outputJar.getName()));
        progressLogger.started();
        try {
            this.createFatJar(outputJar, files, progressLogger);
        }
        finally {
            progressLogger.completed();
        }
    }

    private void createFatJar(File outputJar, final Iterable<? extends File> files, final ProgressLogger progressLogger) {
        File tmpFile;
        try {
            tmpFile = File.createTempFile(outputJar.getName(), ".tmp");
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        IoActions.withResource((Closeable)this.openJarOutputStream(tmpFile), (Action)new ErroringAction<ZipOutputStream>(){

            protected void doExecute(ZipOutputStream jarOutputStream) throws Exception {
                GradleImplDepsRelocatedJarCreator.this.processFiles(jarOutputStream, files, new byte[8192], new HashSet(), new HashMap(), progressLogger);
                jarOutputStream.finish();
            }
        });
        GFileUtils.moveFile((File)tmpFile, (File)outputJar);
    }

    private ZipOutputStream openJarOutputStream(File outputJar) {
        try {
            ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar), 8192));
            outputStream.setLevel(0);
            return outputStream;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void processFiles(ZipOutputStream outputStream, Iterable<? extends File> files, byte[] buffer, HashSet<String> seenPaths, Map<String, List<String>> services, ProgressLogger progressLogger) throws Exception {
        PercentageProgressFormatter progressFormatter = new PercentageProgressFormatter("Generating", Iterables.size(files) + 2);
        for (File file : files) {
            progressLogger.progress(progressFormatter.getProgress());
            if (!file.getName().endsWith(".jar")) {
                throw new RuntimeException("non JAR on classpath: " + file.getAbsolutePath());
            }
            this.processJarFile(outputStream, file, buffer, seenPaths, services);
            progressFormatter.incrementAndGetProgress();
        }
        this.writeServiceFiles(outputStream, services);
        progressFormatter.incrementAndGetProgress();
        this.writeMarkerFile(outputStream);
        progressFormatter.incrementAndGetProgress();
    }

    private void writeServiceFiles(ZipOutputStream outputStream, Map<String, List<String>> services) throws IOException {
        for (Map.Entry<String, List<String>> service : services.entrySet()) {
            String allProviders = Joiner.on((String)"\n").join((Iterable)service.getValue());
            this.writeEntry(outputStream, SERVICES_DIR_PREFIX + service.getKey(), allProviders.getBytes(Charsets.UTF_8));
        }
    }

    private void writeMarkerFile(ZipOutputStream outputStream) throws IOException {
        this.writeEntry(outputStream, "META-INF/gradle-internal/fat.marker", new byte[0]);
    }

    private void processJarFile(final ZipOutputStream outputStream, File file, final byte[] buffer, final HashSet<String> seenPaths, final Map<String, List<String>> services) throws IOException {
        IoActions.withResource((Closeable)this.openJarFile(file), (Action)new ErroringAction<ZipInputStream>(){

            protected void doExecute(ZipInputStream inputStream) throws Exception {
                ZipEntry zipEntry = inputStream.getNextEntry();
                while (zipEntry != null) {
                    String name = zipEntry.getName();
                    if (name.startsWith(GradleImplDepsRelocatedJarCreator.SERVICES_DIR_PREFIX) || seenPaths.add(name)) {
                        GradleImplDepsRelocatedJarCreator.this.processEntry(outputStream, inputStream, zipEntry, buffer, services);
                    }
                    zipEntry = inputStream.getNextEntry();
                }
            }
        });
    }

    private void processEntry(ZipOutputStream outputStream, ZipInputStream inputStream, ZipEntry zipEntry, byte[] buffer, Map<String, List<String>> services) throws IOException {
        String name = zipEntry.getName();
        if (zipEntry.isDirectory() || name.equals("META-INF/MANIFEST.MF")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.processClassFile(outputStream, inputStream, zipEntry, buffer);
        } else if (name.startsWith(SERVICES_DIR_PREFIX)) {
            this.processServiceDescriptor(inputStream, zipEntry, buffer, services);
        } else {
            this.copyEntry(outputStream, inputStream, zipEntry, buffer);
        }
    }

    private void processServiceDescriptor(ZipInputStream inputStream, ZipEntry zipEntry, byte[] buffer, Map<String, List<String>> services) throws IOException {
        byte[] bytes;
        String entry;
        String descriptorImplClass;
        String relocatedImplClassName;
        String descriptorName = zipEntry.getName().substring(SERVICES_DIR_PREFIX.length());
        String descriptorApiClass = this.periodsToSlashes(descriptorName);
        String relocatedApiClassName = REMAPPER.relocateClass(descriptorApiClass);
        if (relocatedApiClassName == null) {
            relocatedApiClassName = descriptorApiClass;
        }
        if ((relocatedImplClassName = REMAPPER.relocateClass(descriptorImplClass = this.periodsToSlashes(entry = new String(bytes = this.readEntry(inputStream, zipEntry, buffer), Charsets.UTF_8).replaceAll("(?m)^#.*", "").trim()))) == null) {
            relocatedImplClassName = descriptorImplClass;
        }
        String serviceType = this.slashesToPeriods(relocatedApiClassName);
        String serviceProvider = this.slashesToPeriods(relocatedImplClassName).trim();
        if (!services.containsKey(serviceType)) {
            services.put(serviceType, Lists.newArrayList((Object[])new String[]{serviceProvider}));
        } else {
            List<String> providers = services.get(serviceType);
            providers.add(serviceProvider);
        }
    }

    private String slashesToPeriods(String slashClassName) {
        return slashClassName.replace('/', '.');
    }

    private String periodsToSlashes(String periodClassName) {
        return periodClassName.replace('.', '/');
    }

    private void copyEntry(ZipOutputStream outputStream, ZipInputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        outputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
        this.pipe(inputStream, outputStream, buffer);
        outputStream.closeEntry();
    }

    private void writeEntry(ZipOutputStream outputStream, String name, byte[] content) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        outputStream.putNextEntry(zipEntry);
        outputStream.write(content);
        outputStream.closeEntry();
    }

    private void processClassFile(ZipOutputStream outputStream, ZipInputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        String className = zipEntry.getName().substring(0, zipEntry.getName().length() - ".class".length());
        byte[] bytes = this.readEntry(inputStream, zipEntry, buffer);
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        RemappingClassAdapter remappingVisitor = new RemappingClassAdapter((ClassVisitor)classWriter, (Remapper)REMAPPER);
        try {
            classReader.accept((ClassVisitor)remappingVisitor, 8);
        }
        catch (Exception e) {
            throw new GradleException("Error in ASM processing class: " + className, (Throwable)e);
        }
        byte[] remappedClass = classWriter.toByteArray();
        String remappedClassName = REMAPPER.relocateClass(className);
        String newFileName = (remappedClassName == null ? className : remappedClassName).concat(".class");
        this.writeEntry(outputStream, newFileName, remappedClass);
    }

    private byte[] readEntry(InputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        int size = (int)zipEntry.getSize();
        if (size == -1) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
            int read = inputStream.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            return out.toByteArray();
        }
        byte[] bytes = new byte[size];
        for (int read = inputStream.read(bytes); read < size; read += inputStream.read(bytes, read, size - read)) {
        }
        return bytes;
    }

    private void pipe(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int read = inputStream.read(buffer);
        while (read != -1) {
            outputStream.write(buffer, 0, read);
            read = inputStream.read(buffer);
        }
    }

    private ZipInputStream openJarFile(File file) throws IOException {
        return new ZipInputStream(new FileInputStream(file));
    }
}

