/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.impldeps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.commons.Remapper;

class GradleImplDepsRelocator
extends Remapper {
    private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+)");

    GradleImplDepsRelocator() {
    }

    public String map(String name) {
        String relocated;
        String value = name;
        String prefix = "";
        Matcher m = this.classPattern.matcher(name);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            name = m.group(2);
        }
        if ((relocated = this.relocateClass(name)) == null) {
            return value;
        }
        return prefix.concat(relocated);
    }

    public String relocateClass(String clazz) {
        if (clazz.startsWith("org/gradle") || clazz.startsWith("java") || clazz.startsWith("javax") || clazz.startsWith("groovy") || clazz.startsWith("net/rubygrapefruit") || clazz.startsWith("org/codehaus/groovy") || clazz.startsWith("org/apache/tools/ant")) {
            return null;
        }
        return "org/gradle/impldep/".concat(clazz);
    }
}

