/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsForIn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsWhile;

public class JsRequiresSemiVisitor
extends JsVisitor {
    private boolean needsSemicolon;

    private JsRequiresSemiVisitor() {
    }

    public static boolean exec(JsStatement lastStatement) {
        JsRequiresSemiVisitor visitor2 = new JsRequiresSemiVisitor();
        visitor2.accept(lastStatement);
        return visitor2.needsSemicolon;
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/JsRequiresSemiVisitor", "visitFor"));
        }
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitForIn(@NotNull JsForIn x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/JsRequiresSemiVisitor", "visitForIn"));
        }
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/JsRequiresSemiVisitor", "visitIf"));
        }
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStmt = x.getElseStatement();
        JsStatement toCheck = thenStmt;
        if (elseStmt != null) {
            toCheck = elseStmt;
        }
        if (toCheck instanceof JsEmpty) {
            this.needsSemicolon = true;
        } else {
            this.accept(toCheck);
        }
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/JsRequiresSemiVisitor", "visitLabel"));
        }
        if (x.getStatement() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/JsRequiresSemiVisitor", "visitWhile"));
        }
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }
}

