/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.gnu.trove.TIntArrayList;

public class BuildNumber
implements Comparable<BuildNumber> {
    @NotNull
    private final String myProductCode;
    private final int[] myComponents;

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "org/jetbrains/kotlin/com/intellij/openapi/util/BuildNumber", "<init>"));
        }
        this(productCode, new int[]{baselineVersion, buildNumber});
    }

    public BuildNumber(@NotNull String productCode, int ... components) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "org/jetbrains/kotlin/com/intellij/openapi/util/BuildNumber", "<init>"));
        }
        this.myProductCode = productCode;
        this.myComponents = components;
    }

    public String asString() {
        return this.asString(true, true);
    }

    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    private String asString(boolean includeProductCode, boolean withSnapshotMarker) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty(this.myProductCode)) {
            builder.append(this.myProductCode).append('-');
        }
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) {
                builder.append(each);
            } else if (withSnapshotMarker) {
                builder.append("SNAPSHOT");
            }
            builder.append('.');
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static BuildNumber fromString(String version) {
        return BuildNumber.fromString(version, null);
    }

    public static BuildNumber fromString(String version, @Nullable String name2) {
        String productCode;
        if (StringUtil.isEmptyOrSpaces(version)) {
            return null;
        }
        if ("__BUILD_NUMBER__".equals(version) || "SNAPSHOT".equals(version)) {
            String productCode2 = name2 != null ? name2 : "";
            return new BuildNumber(productCode2, BuildNumber.currentVersion().myComponents);
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            productCode = "";
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            String baselineVersionString = code.substring(0, baselineVersionSeparator);
            if (baselineVersionString.trim().isEmpty()) {
                return null;
            }
            List<String> stringComponents = StringUtil.split(code, ".");
            TIntArrayList intComponentsList = new TIntArrayList();
            for (String stringComponent : stringComponents) {
                int comp2 = BuildNumber.parseBuildNumber(version, stringComponent, name2);
                intComponentsList.add(comp2);
                if (comp2 != Integer.MAX_VALUE) continue;
                break;
            }
            int[] intComponents = intComponentsList.toNativeArray();
            return new BuildNumber(productCode, intComponents);
        }
        int buildNumber = BuildNumber.parseBuildNumber(version, code, name2);
        if (buildNumber <= 2000) {
            return new BuildNumber(productCode, buildNumber, 0);
        }
        int baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, String code, String name2) {
        if ("SNAPSHOT".equals(code) || "__BUILD_NUMBER__".equals(code)) {
            return Integer.MAX_VALUE;
        }
        if ("*".equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + name2);
        }
    }

    private static BuildNumber fromFile() {
        try {
            String home = PathManager.getHomePath();
            File buildTxtFile = FileUtil.findFirstThatExist(home + "/build.txt", home + "/Resources/build.txt", home + "/community/build.txt");
            if (buildTxtFile != null) {
                String text2 = FileUtil.loadFile(buildTxtFile).trim();
                return BuildNumber.fromString(text2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BuildNumber.fromString("999.SNAPSHOT");
    }

    public static BuildNumber currentVersion() {
        return Holder.CURRENT_VERSION;
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/openapi/util/BuildNumber", "compareTo"));
        }
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i] - c2[i];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result2 = this.myProductCode.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myComponents);
        return result2;
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    public boolean isSnapshot() {
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ BuildNumber access$000() {
        return BuildNumber.fromFile();
    }

    private static class Holder {
        private static final BuildNumber CURRENT_VERSION = BuildNumber.access$000();
    }
}

