/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "<init>"));
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<PsiType>(){

            @Override
            public CachedValueProvider.Result<PsiType> compute() {
                PsiType lub = (PsiType)PsiDisjunctionType.this.myTypes.get(0);
                for (int i = 1; i < PsiDisjunctionType.this.myTypes.size(); ++i) {
                    if ((lub = GenericsUtil.getLeastUpperBound(lub, (PsiType)PsiDisjunctionType.this.myTypes.get(i), PsiDisjunctionType.this.myManager)) != null) continue;
                    lub = PsiType.getJavaLangObject(PsiDisjunctionType.this.myManager, GlobalSearchScope.allScope(PsiDisjunctionType.this.myManager.getProject()));
                    break;
                }
                return CachedValueProvider.Result.create(lub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "createDisjunction"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "createDisjunction"));
        }
        assert (!types.isEmpty());
        PsiType psiType = types.size() == 1 ? types.get(0) : new PsiDisjunctionType(types, psiManager);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "createDisjunction"));
        }
        return psiType;
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        PsiType psiType = this.myLubCache.getValue();
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getLeastUpperBound"));
        }
        return psiType;
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        List<PsiType> list2 = this.myTypes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getDisjunctions"));
        }
        return list2;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        PsiDisjunctionType psiDisjunctionType = new PsiDisjunctionType(types, this.myManager);
        if (psiDisjunctionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "newDisjunctionType"));
        }
        return psiDisjunctionType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, " | ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(final boolean annotated) {
        String string = StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getCanonicalText(annotated);
            }
        }, " | ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = StringUtil.join(this.myTypes, new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getInternalCanonicalText();
            }
        }, " | ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getInternalCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.myTypes) {
            if (type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "equalsToText"));
        }
        return Comparing.equal(text2, this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "accept"));
        }
        return visitor2.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray = ((PsiIntersectionType)lub).getConjuncts();
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getSuperTypes"));
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = new PsiType[]{lub};
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.myTypes.size(); ++i) {
            if (this.myTypes.get(i).equals(that.myTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

